/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl.registry;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.bookshelf.common.api.registry.RegistryHandler;
import net.darkhax.bookshelf.common.api.registry.register.MenuRegister;
import net.darkhax.bookshelf.common.api.registry.register.Register;
import net.darkhax.bookshelf.common.api.registry.register.RegisterItem;
import net.darkhax.bookshelf.common.api.registry.register.RegisterRecipeType;
import net.darkhax.bookshelf.common.api.service.Services;
import net.darkhax.bookshelf.common.impl.recipe.RecipeTypeImpl;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class RegistryHandlers {
    private static final Map<ResourceKey<? extends Registry<?>>, RegistryHandler> HANDLERS = RegistryHandlers.buildHandlers();

    private static Map<ResourceKey<? extends Registry<?>>, RegistryHandler> buildHandlers() {
        HashMap handlers = new HashMap();
        handlers.put(Registries.MOB_EFFECT, registry -> Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerMobEffects(new Register<MobEffect>(provider.contentNamespace(), (id, effect) -> Registry.registerForHolder((Registry)registry, (ResourceLocation)id, (Object)effect)))));
        handlers.put(Registries.BLOCK, registry -> Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerMobEffects(new Register<MobEffect>(provider.contentNamespace(), (id, effect) -> Registry.registerForHolder((Registry)registry, (ResourceLocation)id, (Object)effect)))));
        handlers.put(Registries.ENTITY_TYPE, registry -> Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerEntities(new Register(provider.contentNamespace(), (id, builder) -> Registry.register((Registry)registry, (ResourceLocation)id, (Object)builder.build(id.toString()))))));
        handlers.put(Registries.ITEM, registry -> Services.CONTENT_PROVIDERS.get().forEach(provider -> {
            provider.registerItems(new Register<Item>(provider.contentNamespace(), Items::registerItem));
            provider.registerItems(new RegisterItem(provider.contentNamespace(), Items::registerItem));
        }));
        handlers.put(Registries.BLOCK_ENTITY_TYPE, registry -> Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerBlockEntities(new Register(provider.contentNamespace(), (id, builder) -> Registry.register((Registry)registry, (ResourceLocation)id, (Object)builder.build(null))))));
        handlers.put(Registries.MENU, registry -> Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerMenus(new MenuRegister(provider.contentNamespace()))));
        handlers.put(Registries.RECIPE_TYPE, registry -> Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerRecipeTypes(new RegisterRecipeType(provider.contentNamespace(), id -> Registry.register((Registry)registry, (ResourceLocation)id, new RecipeTypeImpl((ResourceLocation)id))))));
        handlers.put(Registries.RECIPE_SERIALIZER, registry -> Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerRecipeSerializers(new Register(provider.contentNamespace(), (id, serializer) -> Registry.register((Registry)registry, (ResourceLocation)id, (Object)serializer)))));
        handlers.put(Registries.ATTRIBUTE, registry -> Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerAttributes(new Register<Attribute>(provider.contentNamespace(), (id, attribute) -> Registry.register((Registry)registry, (ResourceLocation)id, (Object)attribute)))));
        handlers.put(Registries.LOOT_CONDITION_TYPE, registry -> Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerLootConditions(new Register<MapCodec<? extends LootItemCondition>>(provider.contentNamespace(), (id, codec) -> Registry.register((Registry)registry, (ResourceLocation)id, (Object)new LootItemConditionType(codec))))));
        handlers.put(Registries.LOOT_FUNCTION_TYPE, registry -> Services.CONTENT_PROVIDERS.get().forEach(provider -> provider.registerLootFunctions(new Register<MapCodec<? extends LootItemFunction>>(provider.contentNamespace(), (id, codec) -> Registry.register((Registry)registry, (ResourceLocation)id, (Object)new LootItemFunctionType(codec))))));
        return handlers;
    }

    public static <T, R extends WritableRegistry<T>> void loadContent(ResourceKey<? extends Registry<T>> key, R registry) {
        RegistryHandler handler = HANDLERS.get(key);
        if (handler != null) {
            handler.handle(registry);
        }
    }
}

