/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public interface ILightningConductive {
    public static final Direction[] LIGHTNING_REDIRECTION_FACES = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN};
    public static final Direction[] NO_REDIRECTION_FACES = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.DOWN};

    default public void onDirectLightningStrike(Level world, BlockPos pos, BlockState state, LightningBolt lightning) {
    }

    default public void onIndirectLightingStrike(Level world, BlockPos strikePos, BlockState strikeState, BlockPos indirectPos, BlockState indirectState, LightningBolt lightning) {
    }

    default public boolean canRedirectLightning(Level world, BlockPos strikePos, BlockState strikeState) {
        return strikeState.is(Blocks.LIGHTNING_ROD);
    }

    default public Direction[] getLightningRedirectionFaces(Level world, BlockPos strikePos, BlockState strikeState) {
        return this.canRedirectLightning(world, strikePos, strikeState) ? LIGHTNING_REDIRECTION_FACES : NO_REDIRECTION_FACES;
    }
}

