package net.darkhax.bookshelf.impl.util;

import net.darkhax.bookshelf.api.inventory.IInventoryAccess;
import net.darkhax.bookshelf.api.util.IInventoryHelper;
import net.darkhax.bookshelf.impl.inventory.ItemHandlerInventoryAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;

public class InventoryHelperNeoForge implements IInventoryHelper {

    @Override
    public Player getCraftingPlayer(Container container) {

        final Player player = CommonHooks.getCraftingPlayer();
        return player != null ? player : IInventoryHelper.super.getCraftingPlayer(container);
    }

    @Override
    public boolean canItemsStack(ItemStack original, ItemStack toStack) {

        return ItemHandlerHelper.canItemStacksStack(toStack, original);
    }

    @Nullable
    @Override
    public IInventoryAccess getInventory(Level level, BlockPos pos, @Nullable Direction direction) {

        final IItemHandler inventory = level.getCapability(Capabilities.ItemHandler.BLOCK, pos, direction);

        if (inventory != null) {

            return new ItemHandlerInventoryAccess(inventory);
        }

        return IInventoryHelper.super.getInventory(level, pos, direction);
    }

    @Override
    public void openMenu(ServerPlayer player, MenuProvider provider, Consumer<FriendlyByteBuf> buf) {

        player.openMenu(provider, buf);
    }

    @Override
    public ItemStack getCraftingRemainder(ItemStack stack) {

        return stack.getCraftingRemainingItem();
    }

    @Override
    public boolean hasCraftingRemainder(ItemStack stack) {

        return stack.hasCraftingRemainingItem();
    }
}