/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.mixin.accessors.client.AccessorFontManager;
import net.darkhax.bookshelf.mixin.accessors.client.AccessorMinecraft;
import net.darkhax.bookshelf.mixin.accessors.entity.AccessorEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public final class TextHelper {
    public static final ResourceLocation FONT_DEFAULT = new ResourceLocation("minecraft", "default");
    public static final ResourceLocation FONT_ALT = new ResourceLocation("minecraft", "alt");
    public static final ResourceLocation FONT_ILLAGER = new ResourceLocation("minecraft", "illageralt");
    public static final ResourceLocation FONT_UNIFORM = new ResourceLocation("minecraft", "uniform");

    public static MutableComponent getFormattedTime(int ticks) {
        return TextHelper.getFormattedTime(ticks, true);
    }

    public static MutableComponent getFormattedTime(int ticks, boolean includeHover) {
        return TextHelper.getFormattedTime(ticks, includeHover, 1.0f);
    }

    public static MutableComponent getFormattedTime(int ticks, boolean includeHover, Level level) {
        return TextHelper.getFormattedTime(ticks, includeHover, level.tickRateManager().tickrate());
    }

    public static MutableComponent getFormattedTime(int ticks, boolean includeHover, float tickRate) {
        MutableComponent component = Component.literal((String)StringUtil.formatTickDuration((int)ticks, (float)tickRate));
        if (includeHover) {
            component = TextHelper.setHover((Component)component, (Component)Component.translatable((String)"text.bookshelf.ticks", (Object[])new Object[]{ticks}));
        }
        return component;
    }

    public static MutableComponent setHover(Component component, Component hoverInfo) {
        return TextHelper.setHover(component, HoverEvent.Action.SHOW_TEXT, hoverInfo);
    }

    public static MutableComponent setHover(Component component, Item hoverInfo) {
        return TextHelper.setHover(component, hoverInfo.getDefaultInstance());
    }

    public static MutableComponent setHover(Component component, ItemStack hoverInfo) {
        return TextHelper.setHover(component, HoverEvent.Action.SHOW_ITEM, new HoverEvent.ItemStackInfo(hoverInfo));
    }

    public static MutableComponent setHover(Component component, Entity hoverInfo) {
        if (hoverInfo instanceof AccessorEntity) {
            AccessorEntity accessor = (AccessorEntity)hoverInfo;
            return TextHelper.setHover(component, accessor.bookshelf$createHoverEvent());
        }
        return TextHelper.setHover(component, HoverEvent.Action.SHOW_ENTITY, new HoverEvent.EntityTooltipInfo(hoverInfo.getType(), hoverInfo.getUUID(), hoverInfo.getName()));
    }

    public static <AV, AT extends HoverEvent.Action<AV>> MutableComponent setHover(Component component, AT action, AV value) {
        return TextHelper.setHover(component, new HoverEvent(action, value));
    }

    public static MutableComponent setHover(Component component, HoverEvent hoverInfo) {
        return TextHelper.mutable(component).withStyle(style -> style.withHoverEvent(hoverInfo));
    }

    public static MutableComponent mutable(Component component) {
        MutableComponent mutable;
        return component instanceof MutableComponent ? (mutable = (MutableComponent)component) : component.copy();
    }

    public static Component applyFont(Component text, ResourceLocation font) {
        if (text == CommonComponents.EMPTY) {
            return text;
        }
        MutableComponent modified = text.copy();
        modified.withStyle(style -> style.withFont(font));
        modified.getSiblings().forEach(sib -> TextHelper.applyFont(sib, font));
        return modified;
    }

    public static Set<ResourceLocation> getRegisteredFonts() {
        if (!Services.PLATFORM.isPhysicalClient()) {
            return Collections.emptySet();
        }
        return ((AccessorFontManager)((AccessorMinecraft)Minecraft.getInstance()).bookshelf$getFontManager()).bookshelf$getFonts().keySet();
    }

    @Nullable
    public static MutableComponent lookupTranslationWithAlias(ResourceLocation id, String ... keys) {
        for (String key : keys) {
            MutableComponent lookupResult = TextHelper.lookupTranslation(key.formatted(id.getNamespace(), id.getPath()), new Object[0]);
            if (lookupResult == null) continue;
            return lookupResult;
        }
        return null;
    }

    @Nullable
    public static MutableComponent lookupTranslationWithAlias(String[] keys, Object ... params) {
        for (String key : keys) {
            MutableComponent lookupResult = TextHelper.lookupTranslation(key, params);
            if (lookupResult == null) continue;
            return lookupResult;
        }
        return null;
    }

    @Nullable
    public static MutableComponent lookupTranslation(String key, Object ... args) {
        return TextHelper.lookupTranslation(key, (String s, Object[] o) -> null, args);
    }

    @Nullable
    public static MutableComponent lookupTranslation(String key, MutableComponent fallback, Object ... args) {
        return TextHelper.lookupTranslation(key, (String s, Object[] o) -> fallback, args);
    }

    @Nullable
    public static MutableComponent lookupTranslation(String key, @Nullable BiFunction<String, Object[], MutableComponent> fallback, Object ... args) {
        if (I18n.exists((String)key)) {
            return Component.translatable((String)key, (Object[])args);
        }
        return fallback != null ? fallback.apply(key, args) : null;
    }

    public static MutableComponent textWithCopy(String text) {
        return TextHelper.setCopyText(Component.literal((String)text), text);
    }

    public static MutableComponent setCopyText(MutableComponent component, String copy) {
        return component.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, copy)));
    }

    public static MutableComponent join(Component separator, Component ... toJoin) {
        return TextHelper.join(separator, Arrays.stream(toJoin).iterator());
    }

    public static MutableComponent join(Component separator, Collection<Component> toJoin) {
        return TextHelper.join(separator, toJoin.iterator());
    }

    public static MutableComponent join(Component separator, Iterator<Component> toJoin) {
        MutableComponent joined = Component.literal((String)"");
        while (toJoin.hasNext()) {
            joined.append(toJoin.next());
            if (!toJoin.hasNext()) continue;
            joined.append(separator);
        }
        return joined;
    }

    public static Set<String> getPossibleMatches(String input, Iterable<String> candidates) {
        return TextHelper.getPossibleMatches(input, candidates, Integer.MAX_VALUE);
    }

    public static Set<String> getPossibleMatches(String input, Iterable<String> candidates, int threshold) {
        HashSet<String> bestMatches = new HashSet<String>();
        int distance = threshold;
        for (String candidate : candidates) {
            int currentDistance = StringUtils.getLevenshteinDistance((CharSequence)input, (CharSequence)candidate);
            if (currentDistance < distance) {
                distance = currentDistance;
                bestMatches.clear();
                bestMatches.add(candidate);
                continue;
            }
            if (currentDistance != distance) continue;
            bestMatches.add(candidate);
        }
        return bestMatches;
    }

    public static <T> String formatCollection(Collection<T> collection) {
        return TextHelper.formatCollection(collection, entry -> "\"" + entry.toString() + "\"", ", ");
    }

    public static <T> String formatCollection(Collection<T> collection, Function<T, String> formatter, String delimiter) {
        return collection.size() == 1 ? formatter.apply(collection.stream().findFirst().get()) : collection.stream().map(formatter).collect(Collectors.joining(delimiter));
    }
}

