/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class RenderHelper {
    public static void renderLinesWrapped(GuiGraphics graphics, int x, int y, FormattedText text, int textWidth) {
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(font);
        RenderHelper.renderLinesWrapped(graphics, font, x, y, 9, 0, text, textWidth);
    }

    public static void renderLinesWrapped(GuiGraphics graphics, Font fontRenderer, int x, int y, int spacing, int defaultColor, FormattedText text, int textWidth) {
        RenderHelper.renderLinesWrapped(graphics, fontRenderer, x, y, spacing, defaultColor, fontRenderer.split(text, textWidth));
    }

    public static void renderLinesWrapped(GuiGraphics graphics, Font font, int x, int y, int spacing, int defaultColor, List<FormattedCharSequence> lines) {
        for (int lineNum = 0; lineNum < lines.size(); ++lineNum) {
            FormattedCharSequence lineFragment = lines.get(lineNum);
            graphics.drawString(font, lineFragment, x, y + lineNum * spacing, defaultColor);
        }
    }

    public static int renderLinesReversed(GuiGraphics graphics, int x, int y, FormattedText text, int textWidth) {
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(font);
        return RenderHelper.renderLinesReversed(graphics, font, x, y, 9, 0xFFFFFF, text, textWidth);
    }

    public static int renderLinesReversed(GuiGraphics graphics, Font font, int x, int y, int spacing, int defaultColor, FormattedText text, int textWidth) {
        return RenderHelper.renderLinesReversed(graphics, font, x, y, spacing, defaultColor, font.split(text, textWidth));
    }

    public static int renderLinesReversed(GuiGraphics graphics, Font font, int x, int y, int spacing, int defaultColor, List<FormattedCharSequence> lines) {
        int lineCount = lines.size();
        for (int lineNum = lineCount - 1; lineNum >= 0; --lineNum) {
            FormattedCharSequence lineFragment = lines.get(lineCount - 1 - lineNum);
            graphics.drawString(font, lineFragment, x, y - (lineNum + 1) * (spacing + 1), defaultColor);
        }
        return lineCount * (spacing + 1);
    }
}

