/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import com.google.common.math.DoubleMath;
import java.util.Arrays;
import java.util.Objects;
import net.darkhax.bookshelf.api.util.AttributeHelper;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public final class ItemStackHelper {
    public static double getAttackDamage(ItemStack stack) {
        return ItemStackHelper.getAttackDamage(stack, MobType.UNDEFINED);
    }

    public static double getAttackDamage(ItemStack stack, Entity target) {
        MobType mobType;
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            mobType = living.getMobType();
        } else {
            mobType = MobType.UNDEFINED;
        }
        return ItemStackHelper.getAttackDamage(stack, mobType);
    }

    public static double getAttackDamage(ItemStack stack, MobType targetType) {
        double damage = AttributeHelper.getAttackDamage(stack);
        double bonusEnchantmentDamage = EnchantmentHelper.getDamageBonus((ItemStack)stack, (MobType)targetType);
        return damage + bonusEnchantmentDamage;
    }

    public static ItemStack[] getTabItems(CreativeModeTab tab) {
        return (ItemStack[])tab.getDisplayItems().toArray(ItemStack[]::new);
    }

    public static boolean areStacksEquivalent(ItemStack first, ItemStack second) {
        return ItemStackHelper.areStacksEquivalent(first, second, false);
    }

    public static boolean areStacksContentsEquivalent(ItemStack first, ItemStack second) {
        return ItemStackHelper.areStacksEquivalent(first, second, true);
    }

    public static boolean areStacksEquivalent(ItemStack first, ItemStack second, boolean ignoreTags) {
        return first == null && second == null || first.isEmpty() == second.isEmpty() || first.getCount() == second.getCount() && first.getItem() == second.getItem() && (ignoreTags || ItemStackHelper.areTagsEquivalent((Tag)first.getTag(), (Tag)second.getTag()));
    }

    public static boolean areTagsEquivalent(Tag a, Tag b) {
        if (!Objects.equals(a, b)) {
            if (a instanceof NumericTag) {
                NumericTag numericA = (NumericTag)a;
                if (b instanceof NumericTag) {
                    NumericTag numericB = (NumericTag)b;
                    return ItemStackHelper.areNumericTagsEquivalent(numericA, numericB);
                }
            }
            if (a instanceof CollectionTag) {
                CollectionTag collectionA = (CollectionTag)a;
                if (b instanceof CollectionTag) {
                    CollectionTag collectionB = (CollectionTag)b;
                    return ItemStackHelper.areCollectionTagsEquivalent(collectionA, collectionB);
                }
            }
            if (a instanceof CompoundTag) {
                CompoundTag compoundA = (CompoundTag)a;
                if (b instanceof CompoundTag) {
                    CompoundTag compoundB = (CompoundTag)b;
                    return ItemStackHelper.areCompoundTagsEquivalent(compoundA, compoundB);
                }
            }
        }
        return true;
    }

    public static boolean areCompoundTagsEquivalent(CompoundTag a, CompoundTag b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (String key : a.getAllKeys()) {
            if (ItemStackHelper.areTagsEquivalent((Tag)a.getCompound(key), (Tag)b.getCompound(key))) continue;
            return false;
        }
        return true;
    }

    public static boolean areCollectionTagsEquivalent(CollectionTag<?> a, CollectionTag<?> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int index = 0; index < a.size(); ++index) {
            if (ItemStackHelper.areTagsEquivalent((Tag)a.get(index), (Tag)b.get(index))) continue;
            return false;
        }
        return true;
    }

    public static boolean areNumericTagsEquivalent(NumericTag a, NumericTag b) {
        boolean decimalB;
        boolean decimalA = ItemStackHelper.isDecimal(a);
        if (decimalA == (decimalB = ItemStackHelper.isDecimal(b))) {
            if (decimalA) {
                return Mth.equal((double)a.getAsDouble(), (double)b.getAsDouble());
            }
            return a.getAsLong() == b.getAsLong();
        }
        if (decimalA) {
            return DoubleMath.isMathematicalInteger((double)a.getAsDouble()) && (int)a.getAsDouble() == b.getAsInt();
        }
        return DoubleMath.isMathematicalInteger((double)b.getAsDouble()) && (int)b.getAsDouble() == a.getAsInt();
    }

    public static boolean isDecimal(NumericTag tag) {
        return tag instanceof FloatTag || tag instanceof DoubleTag;
    }

    public static void setLore(ItemStack stack, Component ... lines) {
        CompoundTag displayTag = stack.getOrCreateTagElement("display");
        ListTag loreList = new ListTag();
        Arrays.stream(lines).forEach(line -> loreList.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)line))));
        displayTag.put("Lore", (Tag)loreList);
    }

    public static void appendLore(ItemStack stack, Component ... lines) {
        CompoundTag displayTag = stack.getOrCreateTagElement("display");
        ListTag loreList = displayTag.contains("Lore") ? displayTag.getList("Lore", 8) : new ListTag();
        Arrays.stream(lines).forEach(line -> loreList.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)line))));
        displayTag.put("Lore", (Tag)loreList);
    }
}

