/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.Collection;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public final class AttributeHelper {
    public static double getAttackDamage(ItemStack stack) {
        return AttributeHelper.calculateValue(stack, Attributes.ATTACK_DAMAGE, EquipmentSlot.MAINHAND);
    }

    public static double getAttackSpeed(ItemStack stack) {
        return AttributeHelper.calculateValue(stack, Attributes.ATTACK_SPEED, EquipmentSlot.MAINHAND);
    }

    public static double getAttackKnockback(ItemStack stack) {
        return AttributeHelper.calculateValue(stack, Attributes.ATTACK_KNOCKBACK, EquipmentSlot.MAINHAND);
    }

    public static double calculateValue(ItemStack stack, Attribute attribute, EquipmentSlot slot) {
        return AttributeHelper.calculateValue(attribute, stack.getAttributeModifiers(slot).get((Object)attribute));
    }

    public static double calculateValue(Attribute attribute, Collection<AttributeModifier> modifiers) {
        return attribute.sanitizeValue(AttributeHelper.calculateValue(modifiers, attribute.getDefaultValue()));
    }

    public static double calculateValue(Collection<AttributeModifier> modifiers, double baseValue) {
        double baseTotal = baseValue;
        for (AttributeModifier modifier : modifiers) {
            if (modifier.getOperation() != AttributeModifier.Operation.ADDITION) continue;
            baseTotal += modifier.getAmount();
        }
        double modifiedValue = baseTotal;
        for (AttributeModifier modifier : modifiers) {
            if (modifier.getOperation() != AttributeModifier.Operation.MULTIPLY_BASE) continue;
            modifiedValue += baseTotal * modifier.getAmount();
        }
        for (AttributeModifier modifier : modifiers) {
            if (modifier.getOperation() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            modifiedValue *= 1.0 + modifier.getAmount();
        }
        return modifiedValue;
    }
}

