/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.block;

import net.darkhax.bookshelf.api.block.entity.InventoryBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public abstract class InventoryBlock
extends BaseEntityBlock {
    public InventoryBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(world, pos, state, placer, stack);
        if (stack.hasCustomHoverName() && (blockEntity = world.getBlockEntity(pos)) instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity container = (BaseContainerBlockEntity)blockEntity;
            container.setCustomName(stack.getHoverName());
        }
    }

    public void onRemove(BlockState oldState, Level world, BlockPos pos, BlockState newState, boolean pushed) {
        BlockEntity blockEntity;
        if (!newState.is(oldState.getBlock()) && (blockEntity = world.getBlockEntity(pos)) instanceof InventoryBlockEntity) {
            InventoryBlockEntity invBlock = (InventoryBlockEntity)blockEntity;
            invBlock.dropContents(oldState, world, pos);
        }
        super.onRemove(oldState, world, pos, newState, pushed);
    }
}

