/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest.tests;

import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.api.data.bytebuf.ByteBufHelper;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.darkhax.bookshelf.impl.gametest.TestHelper;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;

public class ByteBufTests<T>
implements ITestable {
    protected final String type;
    protected final ByteBufHelper<T> bufHelper;
    protected final T singleton;
    protected final T[] collection;
    protected final BiPredicate<T, T> equality;

    public ByteBufTests(String type, ByteBufHelper<T> serializer, T ... collection) {
        this(type, (ByteBufHelper<Object>)serializer, Objects::equals, (Object)collection[0], collection);
    }

    public ByteBufTests(String type, ByteBufHelper<T> codecHelper, BiPredicate<T, T> equality, T ... collection) {
        this(type, codecHelper, equality, collection[0], collection);
    }

    public ByteBufTests(String type, ByteBufHelper<T> codecHelper, BiPredicate<T, T> equality, T singleton, T ... collection) {
        this.type = type;
        this.bufHelper = codecHelper;
        this.equality = equality;
        this.singleton = singleton;
        this.collection = collection;
    }

    @GameTest
    public void test_singleton(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.bufHelper.write(buffer, this.singleton);
        T fromBuffer = this.bufHelper.read(buffer);
        if (!this.equality.test(this.singleton, fromBuffer)) {
            helper.fail("Deserialized singleton does not match input! a=" + this.singleton + " b=" + fromBuffer);
            return;
        }
        helper.succeed();
    }

    @GameTest
    public void test_array(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.bufHelper.writeArray(buffer, this.collection);
        T[] fromBuffer = this.bufHelper.readArray(buffer);
        TestHelper.assertEqual(helper, this.collection, fromBuffer, this.equality);
    }

    @GameTest
    public void test_list(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        List<T> inputList = Arrays.asList(this.collection);
        this.bufHelper.writeList(buffer, inputList);
        List<T> fromBuffer = this.bufHelper.readList(buffer);
        TestHelper.assertEqual(helper, inputList, fromBuffer, this.equality);
    }

    @GameTest
    public void test_set(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        Set inputSet = Arrays.stream(this.collection).collect(Collectors.toSet());
        this.bufHelper.writeSet(buffer, inputSet);
        Set<T> fromBuffer = this.bufHelper.readSet(buffer);
        TestHelper.assertEqual(helper, inputSet, fromBuffer, this.equality);
    }

    @GameTest
    public void test_optional(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        Optional<T> input = Optional.of(this.singleton);
        this.bufHelper.writeOptional(buffer, input);
        Optional<T> fromBuffer = this.bufHelper.readOptional(buffer);
        TestHelper.assertEqual(helper, input, fromBuffer, this.equality);
    }

    @GameTest
    public void test_optional_empty(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        Optional input = Optional.empty();
        this.bufHelper.writeOptional(buffer, input);
        Optional<T> fromBuffer = this.bufHelper.readOptional(buffer);
        TestHelper.assertEqual(helper, input, fromBuffer, this.equality);
    }

    @GameTest
    public void test_nullable(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.bufHelper.writeNullable(buffer, this.singleton);
        T fromBuffer = this.bufHelper.readNullable(buffer);
        if (!this.equality.test(this.singleton, fromBuffer)) {
            helper.fail("Deserialized singleton does not match input! a=" + this.singleton + " b=" + fromBuffer);
            return;
        }
        helper.succeed();
    }

    @GameTest
    public void test_nullable_null(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        this.bufHelper.writeNullable(buffer, null);
        T fromBuffer = this.bufHelper.readNullable(buffer);
        if (!this.equality.test(null, fromBuffer)) {
            helper.fail("Deserialized singleton does not match input! a=null b=" + fromBuffer);
            return;
        }
        helper.succeed();
    }

    @GameTest
    public void test_weighted(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        WeightedEntry.Wrapper input = WeightedEntry.wrap(this.singleton, (int)22);
        this.bufHelper.writeWeighted(buffer, input);
        WeightedEntry.Wrapper<T> fromBuffer = this.bufHelper.readWeighted(buffer);
        TestHelper.assertEqual(helper, input, fromBuffer, this.equality);
    }

    @GameTest
    public void test_weighted_list(GameTestHelper helper) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        SimpleWeightedRandomList.Builder builder = new SimpleWeightedRandomList.Builder();
        for (int i = 0; i < this.collection.length; ++i) {
            builder.add(this.collection[i], i * 4);
        }
        SimpleWeightedRandomList input = builder.build();
        this.bufHelper.writeWeightedList(buffer, input);
        SimpleWeightedRandomList<T> fromBuffer = this.bufHelper.readWeightedList(buffer);
        TestHelper.assertEqual(helper, input, fromBuffer, this.equality);
    }

    @Override
    public String getDefaultBatch() {
        return "bookshelf.bytebuf." + this.type;
    }
}

