/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest.tests;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.api.data.codecs.CodecHelper;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.darkhax.bookshelf.impl.gametest.TestHelper;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;

public class CodecTests<T>
implements ITestable {
    protected final String type;
    protected final CodecHelper<T> codecHelper;
    protected final T singleton;
    protected final T[] collection;
    protected final BiPredicate<T, T> equality;

    public CodecTests(String type, CodecHelper<T> serializer, T ... collection) {
        this(type, (CodecHelper<Object>)serializer, Objects::equals, (Object)collection[0], collection);
    }

    public CodecTests(String type, CodecHelper<T> codecHelper, BiPredicate<T, T> equality, T ... collection) {
        this(type, codecHelper, equality, collection[0], collection);
    }

    public CodecTests(String type, CodecHelper<T> codecHelper, BiPredicate<T, T> equality, T singleton, T ... collection) {
        this.type = type;
        this.codecHelper = codecHelper;
        this.equality = equality;
        this.singleton = singleton;
        this.collection = collection;
    }

    @GameTest
    public void test_singleton(GameTestHelper helper) {
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.get(), this.singleton);
        T fromJson = CodecTests.fromJson(helper, this.codecHelper.get(), toJson);
        if (!this.equality.test(this.singleton, fromJson)) {
            helper.fail("Deserialized singleton does not match input! a=" + this.singleton + " b=" + fromJson);
            return;
        }
        helper.succeed();
    }

    @GameTest
    public void test_array(GameTestHelper helper) {
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getArray(), this.collection);
        T[] fromJson = CodecTests.fromJson(helper, this.codecHelper.getArray(), toJson);
        TestHelper.assertEqual(helper, this.collection, fromJson, this.equality);
    }

    @GameTest
    public void test_list(GameTestHelper helper) {
        List<T> inputList = Arrays.asList(this.collection);
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getList(), inputList);
        List<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getList(), toJson);
        if (fromJson.isEmpty()) {
            helper.fail("Found an empty list when non-empty was expected.");
        }
        TestHelper.assertEqual(helper, inputList, fromJson, this.equality);
    }

    @GameTest
    public void test_list_singleton(GameTestHelper helper) {
        List<T> inputList = List.of(this.singleton);
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getList(), inputList);
        List<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getList(), toJson);
        if (fromJson.isEmpty()) {
            helper.fail("Found an empty list when non-empty was expected.");
        }
        TestHelper.assertEqual(helper, inputList, fromJson, this.equality);
    }

    @GameTest
    public void test_list_empty(GameTestHelper helper) {
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getList(), new ArrayList());
        List<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getList(), toJson);
        if (!fromJson.isEmpty()) {
            helper.fail("Expected list to be empty. List=" + fromJson);
        } else {
            helper.succeed();
        }
    }

    @GameTest
    public void test_set(GameTestHelper helper) {
        Set inputSet = Arrays.stream(this.collection).collect(Collectors.toSet());
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getSet(), inputSet);
        Set<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getSet(), toJson);
        TestHelper.assertEqual(helper, inputSet, fromJson, this.equality);
    }

    @GameTest
    public void test_optional(GameTestHelper helper) {
        Optional<T> input = Optional.of(this.singleton);
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getOptional("value"), input);
        Optional<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getOptional("value"), toJson);
        TestHelper.assertEqual(helper, input, fromJson, this.equality);
    }

    @GameTest
    public void test_optional_empty(GameTestHelper helper) {
        Optional input = Optional.empty();
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getOptional("value"), input);
        Optional<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getOptional("value"), toJson);
        TestHelper.assertEqual(helper, input, fromJson, this.equality);
    }

    @GameTest
    public void test_nullable(GameTestHelper helper) {
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getNullable("value"), this.singleton);
        T fromJson = CodecTests.fromJson(helper, this.codecHelper.getNullable("value"), toJson);
        if (!this.equality.test(this.singleton, fromJson)) {
            helper.fail("Deserialized singleton does not match input! a=" + this.singleton + " b=" + fromJson);
            return;
        }
        helper.succeed();
    }

    @GameTest
    public void test_nullable_null(GameTestHelper helper) {
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getNullable("value"), null);
        T fromJson = CodecTests.fromJson(helper, this.codecHelper.getNullable("value"), toJson);
        if (!this.equality.test(null, fromJson)) {
            helper.fail("Deserialized singleton does not match input! a=null b=" + fromJson);
            return;
        }
        helper.succeed();
    }

    @GameTest
    public void test_weighted(GameTestHelper helper) {
        WeightedEntry.Wrapper input = WeightedEntry.wrap(this.singleton, (int)22);
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getWeighted(), input);
        WeightedEntry.Wrapper<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getWeighted(), toJson);
        TestHelper.assertEqual(helper, input, fromJson, this.equality);
    }

    @GameTest
    public void test_weighted_list(GameTestHelper helper) {
        SimpleWeightedRandomList.Builder builder = new SimpleWeightedRandomList.Builder();
        for (int i = 0; i < this.collection.length; ++i) {
            builder.add(this.collection[i], i * 4);
        }
        SimpleWeightedRandomList input = builder.build();
        JsonElement toJson = CodecTests.toJson(helper, this.codecHelper.getWeightedList(), input);
        SimpleWeightedRandomList<T> fromJson = CodecTests.fromJson(helper, this.codecHelper.getWeightedList(), toJson);
        TestHelper.assertEqual(helper, input, fromJson, this.equality);
    }

    @Override
    public String getDefaultBatch() {
        return "bookshelf.codecs." + this.type;
    }

    public static <DT> JsonElement toJson(GameTestHelper helper, MapCodec<DT> codec, DT data) {
        return (JsonElement)codec.encoder().encodeStart((DynamicOps)JsonOps.INSTANCE, data).getOrThrow(false, error -> helper.fail("Failed to serialize: " + error));
    }

    public static <DT> DT fromJson(GameTestHelper helper, MapCodec<DT> codec, JsonElement data) {
        return (DT)((Pair)codec.decoder().decode((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(false, error -> helper.fail("Failed to deserialize: " + error))).getFirst();
    }

    public static <DT> JsonElement toJson(GameTestHelper helper, Codec<DT> codec, DT data) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, data).getOrThrow(false, error -> helper.fail("Failed to serialize: " + error));
    }

    public static <DT> DT fromJson(GameTestHelper helper, Codec<DT> codec, JsonElement json) {
        return (DT)((Pair)codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, error -> helper.fail("Failed to deserialize: " + error))).getFirst();
    }
}

