/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.mixin.patches.entity;

import net.darkhax.bookshelf.api.data.BookshelfTags;
import net.darkhax.bookshelf.api.item.IEquippable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    @Unique
    private int bookshelf$expDamageTimer = 0;

    @Inject(method={"baseTick"}, at={@At(value="RETURN")})
    private void onBaseTick(CallbackInfo cbi) {
        if (!this.level().isClientSide && this.bookshelf$expDamageTimer > 0) {
            --this.bookshelf$expDamageTimer;
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")})
    private void onHurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> callback) {
        if (!this.level().isClientSide && !this.isInvulnerableTo(source) && source.is(BookshelfTags.DamageTypes.CAUSE_EXP_DROPS)) {
            this.bookshelf$expDamageTimer = 100;
        }
    }

    @Inject(method={"isAlwaysExperienceDropper"}, at={@At(value="RETURN")}, cancellable=true)
    private void onExpDropTest(CallbackInfoReturnable<Boolean> callback) {
        if (!this.level().isClientSide && this.bookshelf$expDamageTimer > 0) {
            callback.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getEquipmentSlotForItem(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/world/entity/EquipmentSlot;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void getEquipmentSlotForItem(ItemStack itemStack, CallbackInfoReturnable<EquipmentSlot> callback) {
        IEquippable equippable = IEquippable.get(itemStack);
        if (equippable != null) {
            callback.setReturnValue((Object)equippable.getEquipmentSlot(itemStack));
        }
    }

    private MixinLivingEntity() {
        super(null, null);
    }
}

