/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.item.tab;

import java.util.function.Supplier;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.item.tab.IDisplayGenerator;
import net.darkhax.bookshelf.api.item.tab.ITabBuilder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;

public class TabBuilder
implements ITabBuilder {
    private final CreativeModeTab.Builder delegate;

    public TabBuilder(CreativeModeTab.Builder delegate) {
        this.delegate = delegate;
    }

    @Override
    public ITabBuilder title(Component tabTitle) {
        this.delegate.title(tabTitle);
        return this;
    }

    @Override
    public ITabBuilder icon(Supplier<ItemStack> supplier) {
        this.delegate.icon(supplier);
        return this;
    }

    @Override
    public ITabBuilder displayItems(IDisplayGenerator displayGen) {
        this.delegate.displayItems(Services.CONSTRUCTS.wrapDisplayGen(displayGen));
        return this;
    }

    @Override
    public ITabBuilder hideTitle() {
        this.delegate.hideTitle();
        return this;
    }

    @Override
    public ITabBuilder noScrollBar() {
        this.delegate.noScrollBar();
        return this;
    }

    @Override
    public ITabBuilder backgroundSuffix(String background) {
        this.delegate.backgroundSuffix(background);
        return this;
    }

    @Override
    public CreativeModeTab build() {
        return this.delegate.build();
    }
}

