/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public final class ShapedDurabilityRecipe
extends ShapedRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final ShapedRecipePattern pattern;
    private final int damageAmount;
    private final ItemStack output;

    public ShapedDurabilityRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean notify, int damageAmount) {
        super(group, category, pattern, result, notify);
        this.pattern = pattern;
        this.damageAmount = damageAmount;
        this.output = result;
    }

    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList keptItems = super.getRemainingItems((Container)inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, (NonNullList<ItemStack>)keptItems, this.damageAmount);
    }

    private ShapedRecipePattern getPattern() {
        return this.pattern;
    }

    private ItemStack getRecipeOutput() {
        return this.output;
    }

    private int getDamageAmount() {
        return this.damageAmount;
    }

    public static final class Serializer
    implements RecipeSerializer<ShapedDurabilityRecipe> {
        public static final Codec<ShapedDurabilityRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(ShapedRecipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(ShapedRecipe::category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(ShapedDurabilityRecipe::getPattern), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("result").forGetter(ShapedDurabilityRecipe::getRecipeOutput), (App)ExtraCodecs.strictOptionalField((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(ShapedRecipe::showNotification), BookshelfCodecs.INT.get("damageAmount", ShapedDurabilityRecipe::getDamageAmount)).apply((Applicative)instance, ShapedDurabilityRecipe::new));

        public Codec<ShapedDurabilityRecipe> codec() {
            return CODEC;
        }

        public ShapedDurabilityRecipe fromNetwork(FriendlyByteBuf buffer) {
            String group = buffer.readUtf();
            CraftingBookCategory category = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern pattern = ShapedRecipePattern.fromNetwork((FriendlyByteBuf)buffer);
            ItemStack output = buffer.readItem();
            boolean showNotif = buffer.readBoolean();
            int damageAmount = buffer.readInt();
            return new ShapedDurabilityRecipe(group, category, pattern, output, showNotif, damageAmount);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedDurabilityRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeEnum((Enum)recipe.category());
            recipe.pattern.toNetwork(buffer);
            buffer.writeItem(recipe.output);
            buffer.writeBoolean(recipe.showNotification());
            buffer.writeInt(recipe.damageAmount);
        }
    }
}

