/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.data.conditions.impl;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import java.util.function.Supplier;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.bookshelf.api.data.conditions.ILoadCondition;
import net.darkhax.bookshelf.api.data.conditions.LoadConditions;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;

public class SpecificRegistryContains<T>
implements ILoadCondition {
    private final Registry<T> registry;
    private final Set<ResourceLocation> requiredIds;
    private final Supplier<LoadConditions.ConditionType> getType;

    public static <RT> LoadConditions.ConditionType of(String key, Registry<RT> registry) {
        ResourceLocation typeId = Constants.id(key);
        Codec codec = RecordCodecBuilder.create(instance -> instance.group(BookshelfCodecs.RESOURCE_LOCATION.getSet("values", SpecificRegistryContains::getRequiredEntries)).apply((Applicative)instance, requiredEntries -> new SpecificRegistryContains(registry, (Set<ResourceLocation>)requiredEntries, () -> LoadConditions.getType(typeId))));
        return LoadConditions.register(typeId, codec);
    }

    private SpecificRegistryContains(Registry<T> registry, Set<ResourceLocation> requiredIds, Supplier<LoadConditions.ConditionType> getType) {
        this.registry = registry;
        this.requiredIds = requiredIds;
        this.getType = getType;
    }

    @Override
    public boolean allowLoading() {
        for (ResourceLocation id : this.requiredIds) {
            if (this.registry.containsKey(id)) continue;
            return false;
        }
        return true;
    }

    public Set<ResourceLocation> getRequiredEntries() {
        return this.requiredIds;
    }

    @Override
    public LoadConditions.ConditionType getType() {
        return this.getType.get();
    }
}

