/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf;

import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.block.entity.WorldlyInventoryBlockEntity;
import net.darkhax.bookshelf.api.util.IConstructHelper;
import net.darkhax.bookshelf.impl.BookshelfCommon;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

@Mod(value="bookshelf")
public class BookshelfNeoForge {
    private static final ResourceLocation WORLDLY_CONTAINER_WRAPPER = Constants.id("worldly_container_wrapper");
    private static final BlockCapability<IItemHandler, Direction> WRAPPER_CAP = BlockCapability.createSided((ResourceLocation)WORLDLY_CONTAINER_WRAPPER, IItemHandler.class);

    public BookshelfNeoForge(IEventBus modBus) {
        new BookshelfCommon();
        modBus.addListener(this::attachBlockCapabilities);
    }

    private void attachBlockCapabilities(RegisterCapabilitiesEvent event) {
        for (BlockEntityType type : BuiltInRegistries.BLOCK_ENTITY_TYPE) {
            Class<?> blockEntityClass;
            if (!IConstructHelper.TYPE_CLASSES.containsKey(type) || !WorldlyInventoryBlockEntity.class.isAssignableFrom(blockEntityClass = IConstructHelper.TYPE_CLASSES.get(type))) continue;
            event.registerBlockEntity(WRAPPER_CAP, type, (blockEntity, side) -> {
                if (blockEntity instanceof WorldlyInventoryBlockEntity) {
                    WorldlyInventoryBlockEntity worldly = (WorldlyInventoryBlockEntity)((Object)blockEntity);
                    return side != null ? new SidedInvWrapper((WorldlyContainer)worldly, side) : new InvWrapper((Container)worldly);
                }
                return null;
            });
        }
    }
}

