/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;

public class SerializerEnchantmentInstance
implements ISerializer<EnchantmentInstance> {
    public static final ISerializer<EnchantmentInstance> SERIALIZER = new SerializerEnchantmentInstance();

    private SerializerEnchantmentInstance() {
    }

    @Override
    public EnchantmentInstance fromJSON(JsonElement json) {
        if (json instanceof JsonObject) {
            JsonObject obj = (JsonObject)json;
            Enchantment enchantment = Serializers.ENCHANTMENT.fromJSON(obj, "enchantment");
            int level = Serializers.INT.fromJSON(obj, "level");
            return new EnchantmentInstance(enchantment, level);
        }
        throw new JsonParseException("Expected a JSON object.");
    }

    @Override
    public JsonElement toJSON(EnchantmentInstance toWrite) {
        JsonObject json = new JsonObject();
        Serializers.ENCHANTMENT.toJSON(json, "enchantment", toWrite.enchantment);
        Serializers.INT.toJSON(json, "level", toWrite.level);
        return json;
    }

    @Override
    public EnchantmentInstance fromByteBuf(FriendlyByteBuf buffer) {
        Enchantment enchantment = Serializers.ENCHANTMENT.fromByteBuf(buffer);
        int level = Serializers.INT.fromByteBuf(buffer);
        return new EnchantmentInstance(enchantment, level);
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, EnchantmentInstance toWrite) {
        Serializers.ENCHANTMENT.toByteBuf(buffer, toWrite.enchantment);
        Serializers.INT.toByteBuf(buffer, toWrite.level);
    }

    @Override
    public Tag toNBT(EnchantmentInstance toWrite) {
        CompoundTag tag = new CompoundTag();
        Serializers.ENCHANTMENT.toNBT(tag, "id", toWrite.enchantment);
        Serializers.INT.toNBT(tag, "lvl", toWrite.level);
        return tag;
    }

    @Override
    public EnchantmentInstance fromNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)nbt;
            Enchantment enchantment = Serializers.ENCHANTMENT.fromNBT(compound, "id");
            int level = Serializers.INT.fromNBT(compound, "lvl");
            return new EnchantmentInstance(enchantment, level);
        }
        throw new NBTParseException("Expected a compound tag. " + nbt);
    }
}

