/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.concurrent.atomic.AtomicInteger;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.event.IEventHelper;
import net.darkhax.bookshelf.api.event.block.IFarmlandTrampleListener;
import net.darkhax.bookshelf.api.event.client.IRecipeSyncEvent;
import net.darkhax.bookshelf.api.event.entity.IItemUseTickEvent;
import net.darkhax.bookshelf.api.event.entity.player.IPlayerWakeUpEvent;
import net.darkhax.bookshelf.api.event.item.IItemAttributeEvent;
import net.darkhax.bookshelf.api.event.item.IItemTooltipEvent;
import net.darkhax.bookshelf.impl.event.NeoForgeItemAttributeEvent;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerWakeUpEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

public class EventHelperNeoForge
implements IEventHelper {
    private static final Multimap<EventPriority, IItemAttributeEvent.Listener> ITEM_ATTRIBUTE_LISTENERS = HashMultimap.create();
    private static final Multimap<EventPriority, IItemUseTickEvent> ITEM_USE_TICK_LISTENERS = HashMultimap.create();

    @Override
    public void addItemTooltipListener(IItemTooltipEvent listener, IEventHelper.Ordering ordering) {
        if (Services.PLATFORM.isPhysicalClient()) {
            NeoForge.EVENT_BUS.addListener(EventHelperNeoForge.priority(ordering), false, ItemTooltipEvent.class, e -> listener.apply(e.getItemStack(), e.getToolTip(), e.getFlags()));
        }
    }

    @Override
    public void addPlayerWakeUpListener(IPlayerWakeUpEvent listener, IEventHelper.Ordering ordering) {
        NeoForge.EVENT_BUS.addListener(EventHelperNeoForge.priority(ordering), false, PlayerWakeUpEvent.class, e -> listener.apply(e.getEntity()));
    }

    @Override
    public void addRecipeSyncListener(IRecipeSyncEvent listener, IEventHelper.Ordering ordering) {
        if (Services.PLATFORM.isPhysicalClient()) {
            NeoForge.EVENT_BUS.addListener(EventHelperNeoForge.priority(ordering), false, RecipesUpdatedEvent.class, e -> listener.apply(e.getRecipeManager()));
        }
    }

    @Override
    public void addFarmlandTrampleListener(IFarmlandTrampleListener listener, IEventHelper.Ordering ordering) {
        EventPriority priority = EventHelperNeoForge.priority(ordering);
        NeoForge.EVENT_BUS.addListener(priority, false, BlockEvent.FarmlandTrampleEvent.class, e -> {
            if (listener.apply(e.getEntity(), e.getPos(), e.getState())) {
                e.setCanceled(true);
            }
        });
    }

    @Override
    public void addItemAttributeListener(IItemAttributeEvent.Listener listener, IEventHelper.Ordering ordering) {
        EventPriority priority = EventHelperNeoForge.priority(ordering);
        if (!ITEM_ATTRIBUTE_LISTENERS.containsKey((Object)priority)) {
            NeoForge.EVENT_BUS.addListener(priority, false, ItemAttributeModifierEvent.class, e -> {
                NeoForgeItemAttributeEvent wrapper = new NeoForgeItemAttributeEvent((ItemAttributeModifierEvent)e);
                ITEM_ATTRIBUTE_LISTENERS.get((Object)priority).forEach(entry -> entry.accept(wrapper));
            });
        }
        ITEM_ATTRIBUTE_LISTENERS.put((Object)priority, (Object)listener);
    }

    @Override
    public void addItemUseTickListener(IItemUseTickEvent listener, IEventHelper.Ordering ordering) {
        EventPriority priority = EventHelperNeoForge.priority(ordering);
        if (!ITEM_USE_TICK_LISTENERS.containsKey((Object)priority)) {
            NeoForge.EVENT_BUS.addListener(EventHelperNeoForge.priority(ordering), false, LivingEntityUseItemEvent.Tick.class, e -> {
                AtomicInteger duration = new AtomicInteger(e.getDuration());
                ITEM_USE_TICK_LISTENERS.get((Object)priority).forEach(entry -> entry.onUseTick(e.getEntity(), e.getItem(), duration));
                e.setDuration(duration.get());
            });
        }
        ITEM_USE_TICK_LISTENERS.put((Object)priority, (Object)listener);
    }

    private static EventPriority priority(IEventHelper.Ordering ordering) {
        return switch (ordering) {
            case IEventHelper.Ordering.BEFORE -> EventPriority.HIGH;
            case IEventHelper.Ordering.DEFAULT -> EventPriority.NORMAL;
            case IEventHelper.Ordering.AFTER -> EventPriority.LOW;
            default -> EventPriority.NORMAL;
        };
    }
}

