/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest;

import com.google.common.base.CaseFormat;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiPredicate;
import net.darkhax.bookshelf.Constants;
import net.darkhax.bookshelf.api.data.bytebuf.BookshelfByteBufs;
import net.darkhax.bookshelf.api.data.bytebuf.ByteBufHelper;
import net.darkhax.bookshelf.api.data.bytebuf.RegistryByteBufHelper;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.darkhax.bookshelf.api.data.codecs.CodecHelper;
import net.darkhax.bookshelf.api.data.codecs.RegistryCodecHelper;
import net.darkhax.bookshelf.api.data.sound.Sound;
import net.darkhax.bookshelf.api.item.ItemStackBuilder;
import net.darkhax.bookshelf.api.util.ItemStackHelper;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.darkhax.bookshelf.impl.gametest.TestHelper;
import net.darkhax.bookshelf.impl.gametest.tests.ByteBufTests;
import net.darkhax.bookshelf.impl.gametest.tests.CodecTests;
import net.darkhax.bookshelf.impl.gametest.tests.ItemStackTests;
import net.darkhax.bookshelf.impl.gametest.tests.RegistryCodecTests;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestGenerator;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatType;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.FloatProviderType;
import net.minecraft.util.valueproviders.IntProviderType;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.PositionSourceType;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicateType;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSizeType;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProviderType;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.levelgen.heightproviders.HeightProviderType;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifierType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.nbt.LootNbtProviderType;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import org.apache.commons.lang3.StringUtils;
import org.joml.Vector3f;

public class BookshelfGameTests {
    @GameTestGenerator
    public static Collection<TestFunction> generate() {
        ArrayList<TestFunction> testFunctions = new ArrayList<TestFunction>();
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.BOOLEAN, BookshelfCodecs.BOOLEAN, false, true, true, false);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.BYTE, BookshelfCodecs.BYTE, (byte)1, (byte)32, (byte)44, (byte)0);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.SHORT, BookshelfCodecs.SHORT, (short)800, (short)1337);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.INT, BookshelfCodecs.INT, 54, 23, Integer.MAX_VALUE, 234234, Integer.MIN_VALUE);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.LONG, BookshelfCodecs.LONG, 99L, 23441322L, Long.MIN_VALUE, 93015L, Long.MAX_VALUE);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.FLOAT, BookshelfCodecs.FLOAT, Float.valueOf(8.0f), Float.valueOf(-23.456f), Float.valueOf(789.01f), Float.valueOf(Float.MAX_VALUE), Float.valueOf(-11.0f), Float.valueOf(Float.MIN_VALUE));
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.DOUBLE, BookshelfCodecs.DOUBLE, 24.92, Double.MAX_VALUE, -922321.12345, Double.MIN_VALUE);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.STRING, BookshelfCodecs.STRING, "one", "two", "3", "IV", ".....", "/I", "!@#$%^&*()_-");
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.UUID, BookshelfCodecs.UUID, UUID.randomUUID(), UUID.fromString("da0317d2-e550-11ec-8fea-0242ac120002"), UUID.randomUUID());
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.RESOURCE_LOCATION, BookshelfCodecs.RESOURCE_LOCATION, new ResourceLocation("hello_world"), new ResourceLocation("test", "two"), new ResourceLocation("test_from", "stuff/things/okay_stuff"));
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ITEM_STACK, BookshelfCodecs.ITEM_STACK, ItemStackHelper::areStacksEquivalent, BookshelfGameTests.getTestStacks());
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.COMPOUND_TAG, BookshelfCodecs.COMPOUND_TAG, ItemStackHelper::areTagsEquivalent, BookshelfGameTests.getTestTags());
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.TEXT, BookshelfCodecs.TEXT, Component.translatable((String)"moon.phase.full").withStyle(ChatFormatting.DARK_AQUA), Component.literal((String)"Hello World"), Component.literal((String)"okay").withStyle(s -> s.withFont(new ResourceLocation("minecraft:alt"))));
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.BLOCK_POS, BookshelfCodecs.BLOCK_POS, new BlockPos(1, 2, 3), new BlockPos(0, 0, 0), BlockPos.of((long)123456L));
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.INGREDIENT, BookshelfCodecs.INGREDIENT, TestHelper::assertEqual, new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE_AXE}), Ingredient.EMPTY, Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL}), Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.ACACIA_BOAT)}), Ingredient.of((TagKey)ItemTags.BEDS)});
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.BLOCK_STATE, BookshelfCodecs.BLOCK_STATE, Blocks.STONE.defaultBlockState(), Blocks.CHEST.defaultBlockState(), (BlockState)Blocks.ACACIA_PRESSURE_PLATE.defaultBlockState().setValue((Property)PressurePlateBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ATTRIBUTE_MODIFIER, BookshelfCodecs.ATTRIBUTE_MODIFIER, new AttributeModifier("test", 15.0, AttributeModifier.Operation.MULTIPLY_BASE), new AttributeModifier(UUID.randomUUID(), "test_2", 9.55, AttributeModifier.Operation.ADDITION), new AttributeModifier("test3", 35.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.EFFECT_INSTANCE, BookshelfCodecs.EFFECT_INSTANCE, new MobEffectInstance(MobEffects.ABSORPTION, 100, 10), new MobEffectInstance(MobEffects.BAD_OMEN, 10));
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ENCHANTMENT_INSTANCE, BookshelfCodecs.ENCHANTMENT_INSTANCE, TestHelper::assertEqual, new EnchantmentInstance[]{new EnchantmentInstance(Enchantments.ALL_DAMAGE_PROTECTION, 5), new EnchantmentInstance(Enchantments.BINDING_CURSE, 15), new EnchantmentInstance(Enchantments.IMPALING, 2)});
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.VECTOR_3F, BookshelfCodecs.VECTOR_3F, new Vector3f(1.0f, 2.0f, 3.0f), new Vector3f(-5.0f, -2.0f, 44.0f), new Vector3f(Float.MAX_VALUE, Float.MIN_VALUE, Float.MIN_VALUE));
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.SOUND, BookshelfCodecs.SOUND, new Sound(SoundEvents.DOLPHIN_JUMP, SoundSource.AMBIENT, 1.0f, 1.0f), new Sound(SoundEvents.ALLAY_HURT, SoundSource.NEUTRAL, 0.5f, 0.222f), new Sound(SoundEvents.SQUID_AMBIENT, SoundSource.PLAYERS, 0.1f, 0.2f));
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ITEM_RARITY, BookshelfCodecs.ITEM_RARITY, Rarity.COMMON, Rarity.EPIC, Rarity.RARE, Rarity.RARE);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ENCHANTMENT_RARITY, BookshelfCodecs.ENCHANTMENT_RARITY, Enchantment.Rarity.COMMON, Enchantment.Rarity.COMMON, Enchantment.Rarity.RARE, Enchantment.Rarity.UNCOMMON);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ATTRIBUTE_OPERATION, BookshelfCodecs.ATTRIBUTE_OPERATION, AttributeModifier.Operation.ADDITION, AttributeModifier.Operation.ADDITION, AttributeModifier.Operation.MULTIPLY_BASE, AttributeModifier.Operation.MULTIPLY_TOTAL, AttributeModifier.Operation.MULTIPLY_TOTAL);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.DIRECTION, BookshelfCodecs.DIRECTION, Direction.UP, Direction.UP, Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.SOUTH);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.AXIS, BookshelfCodecs.AXIS, Direction.Axis.X, Direction.Axis.X, Direction.Axis.Y, Direction.Axis.Z, Direction.Axis.Y);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.PLANE, BookshelfCodecs.PLANE, Direction.Plane.HORIZONTAL, Direction.Plane.VERTICAL, Direction.Plane.VERTICAL, Direction.Plane.VERTICAL, Direction.Plane.HORIZONTAL);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.MOB_CATEGORY, BookshelfCodecs.MOB_CATEGORY, MobCategory.AMBIENT, MobCategory.AXOLOTLS, MobCategory.CREATURE, MobCategory.AXOLOTLS, MobCategory.MONSTER, MobCategory.MISC);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ENCHANTMENT_CATEGORY, BookshelfCodecs.ENCHANTMENT_CATEGORY, EnchantmentCategory.ARMOR, EnchantmentCategory.BREAKABLE, EnchantmentCategory.BREAKABLE);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.DYE_COLOR, BookshelfCodecs.DYE_COLOR, DyeColor.BLACK, DyeColor.RED, DyeColor.BLUE);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.SOUND_SOURCE, BookshelfCodecs.SOUND_SOURCE, SoundSource.AMBIENT, SoundSource.HOSTILE, SoundSource.PLAYERS);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ARMOR_MATERIAL, BookshelfCodecs.ARMOR_MATERIAL, ArmorMaterials.CHAIN, ArmorMaterials.DIAMOND, ArmorMaterials.IRON, ArmorMaterials.TURTLE);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.DIFFICULTY, BookshelfCodecs.DIFFICULTY, Difficulty.EASY, Difficulty.EASY, Difficulty.HARD, Difficulty.NORMAL, Difficulty.HARD, Difficulty.PEACEFUL);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.EQUIPMENT_SLOT, BookshelfCodecs.EQUIPMENT_SLOT, EquipmentSlot.CHEST, EquipmentSlot.CHEST, EquipmentSlot.MAINHAND, EquipmentSlot.FEET, EquipmentSlot.MAINHAND);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.MIRROR, BookshelfCodecs.MIRROR, Mirror.FRONT_BACK, Mirror.LEFT_RIGHT, Mirror.NONE, Mirror.LEFT_RIGHT);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ROTATION, BookshelfCodecs.ROTATION, Rotation.NONE, Rotation.CLOCKWISE_90, Rotation.CLOCKWISE_180, Rotation.CLOCKWISE_90);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.GAME_EVENT, BookshelfCodecs.GAME_EVENT, new GameEvent[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.SOUND_EVENT, BookshelfCodecs.SOUND_EVENT, new SoundEvent[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.FLUID, BookshelfCodecs.FLUID, new Fluid[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.MOB_EFFECT, BookshelfCodecs.MOB_EFFECT, new MobEffect[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.BLOCK, BookshelfCodecs.BLOCK, new Block[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ENCHANTMENT, BookshelfCodecs.ENCHANTMENT, new Enchantment[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ENTITY_TYPE, BookshelfCodecs.ENTITY_TYPE, new EntityType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ITEM, BookshelfCodecs.ITEM, new Item[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.POTION, BookshelfCodecs.POTION, new Potion[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.PARTICLE_TYPE, BookshelfCodecs.PARTICLE_TYPE, new ParticleType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.BLOCK_ENTITY_TYPE, BookshelfCodecs.BLOCK_ENTITY_TYPE, new BlockEntityType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.PAINTING_VARIANT, BookshelfCodecs.PAINTING_VARIANT, new PaintingVariant[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.CUSTOM_STAT, BookshelfCodecs.CUSTOM_STAT, new ResourceLocation[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.CHUNK_STATUS, BookshelfCodecs.CHUNK_STATUS, new ChunkStatus[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.RULE_TEST, BookshelfCodecs.RULE_TEST, new RuleTestType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.RULE_BLOCK_ENTITY_MODIFIER, BookshelfCodecs.RULE_BLOCK_ENTITY_MODIFIER, new RuleBlockEntityModifierType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.POS_RULE_TEST, BookshelfCodecs.POS_RULE_TEST, new PosRuleTestType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.MENU, BookshelfCodecs.MENU, new MenuType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.RECIPE_TYPE, BookshelfCodecs.RECIPE_TYPE, new RecipeType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.RECIPE_SERIALIZER, BookshelfCodecs.RECIPE_SERIALIZER, new RecipeSerializer[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ATTRIBUTE, BookshelfCodecs.ATTRIBUTE, new Attribute[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.POSITION_SOURCE_TYPE, BookshelfCodecs.POSITION_SOURCE_TYPE, new PositionSourceType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ARGUMENT_TYPE_INFO_CODEC_HELPER, BookshelfCodecs.ARGUMENT_TYPE_INFO_CODEC_HELPER, new ArgumentTypeInfo[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.STAT_TYPE, BookshelfCodecs.STAT_TYPE, new StatType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.VILLAGER_TYPE, BookshelfCodecs.VILLAGER_TYPE, new VillagerType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.VILLAGER_PROFESSION, BookshelfCodecs.VILLAGER_PROFESSION, new VillagerProfession[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.POINT_OF_INTEREST_TYPE, BookshelfCodecs.POINT_OF_INTEREST_TYPE, new PoiType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.MEMORY_MODULE_TYPE, BookshelfCodecs.MEMORY_MODULE_TYPE, new MemoryModuleType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.SENSOR_TYPE, BookshelfCodecs.SENSOR_TYPE, new SensorType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.SCHEDULE, BookshelfCodecs.SCHEDULE, new Schedule[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ACTIVITY, BookshelfCodecs.ACTIVITY, new Activity[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.LOOT_POOL_ENTRY_TYPE, BookshelfCodecs.LOOT_POOL_ENTRY_TYPE, new LootPoolEntryType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.LOOT_FUNCTION_TYPE, BookshelfCodecs.LOOT_FUNCTION_TYPE, new LootItemFunctionType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.LOOT_CONDITION_TYPE, BookshelfCodecs.LOOT_CONDITION_TYPE, new LootItemConditionType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.LOOT_NUMBER_PROVIDER_TYPE, BookshelfCodecs.LOOT_NUMBER_PROVIDER_TYPE, new LootNumberProviderType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.LOOT_NBT_PROVIDER_TYPE, BookshelfCodecs.LOOT_NBT_PROVIDER_TYPE, new LootNbtProviderType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.LOOT_SCORE_PROVIDER_TYPE, BookshelfCodecs.LOOT_SCORE_PROVIDER_TYPE, new LootScoreProviderType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.FLOAT_PROVIDER_TYPE, BookshelfCodecs.FLOAT_PROVIDER_TYPE, new FloatProviderType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.INT_PROVIDER_TYPE, BookshelfCodecs.INT_PROVIDER_TYPE, new IntProviderType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.HEIGHT_PROVIDER_TYPE, BookshelfCodecs.HEIGHT_PROVIDER_TYPE, new HeightProviderType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.BLOCK_PREDICATE_TYPE, BookshelfCodecs.BLOCK_PREDICATE_TYPE, new BlockPredicateType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.CARVER, BookshelfCodecs.CARVER, new WorldCarver[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.FEATURE, BookshelfCodecs.FEATURE, new Feature[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.STRUCTURE_PLACEMENT, BookshelfCodecs.STRUCTURE_PLACEMENT, new StructurePlacementType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.STRUCTURE_PIECE, BookshelfCodecs.STRUCTURE_PIECE, new StructurePieceType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.STRUCTURE_TYPE, BookshelfCodecs.STRUCTURE_TYPE, new StructureType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.PLACEMENT_MODIFIER_TYPE, BookshelfCodecs.PLACEMENT_MODIFIER_TYPE, new PlacementModifierType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.BLOCKSTATE_PROVIDER_TYPE, BookshelfCodecs.BLOCKSTATE_PROVIDER_TYPE, new BlockStateProviderType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.FOLIAGE_PLACER_TYPE, BookshelfCodecs.FOLIAGE_PLACER_TYPE, new FoliagePlacerType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.TRUNK_PLACER_TYPE, BookshelfCodecs.TRUNK_PLACER_TYPE, new TrunkPlacerType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.ROOT_PLACER_TYPE, BookshelfCodecs.ROOT_PLACER_TYPE, new RootPlacerType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.TREE_DECORATOR_TYPE, BookshelfCodecs.TREE_DECORATOR_TYPE, new TreeDecoratorType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.FEATURE_SIZE_TYPE, BookshelfCodecs.FEATURE_SIZE_TYPE, new FeatureSizeType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.STRUCTURE_PROCESSOR, BookshelfCodecs.STRUCTURE_PROCESSOR, new StructureProcessorType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.STRUCTURE_POOL_ELEMENT, BookshelfCodecs.STRUCTURE_POOL_ELEMENT, new StructurePoolElementType[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.CAT_VARIANT, BookshelfCodecs.CAT_VARIANT, new CatVariant[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.FROG_VARIANT, BookshelfCodecs.FROG_VARIANT, new FrogVariant[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.BANNER_PATTERN, BookshelfCodecs.BANNER_PATTERN, new BannerPattern[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.INSTRUMENT, BookshelfCodecs.INSTRUMENT, new Instrument[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.DECORATED_POT_PATTERNS, BookshelfCodecs.DECORATED_POT_PATTERNS, new String[0]);
        BookshelfGameTests.testFrom(testFunctions, BookshelfByteBufs.CREATIVE_MODE_TAB, BookshelfCodecs.CREATIVE_MODE_TAB, new CreativeModeTab[0]);
        BookshelfGameTests.testFrom(testFunctions, new ItemStackTests());
        return testFunctions;
    }

    private static <T> void testFrom(Collection<TestFunction> functions, ByteBufHelper<T> bufferHelper, CodecHelper<T> codecHelper, T ... collection) {
        BookshelfGameTests.testFrom(functions, bufferHelper, codecHelper, Objects::equals, collection);
    }

    private static <T> void testFrom(Collection<TestFunction> functions, RegistryByteBufHelper<T> bufferHelper, RegistryCodecHelper<T> codecHelper, T ... collection) {
        A[] testArray = codecHelper.getRegistry().stream().limit(5L).toArray(size -> (Object[])Array.newInstance(collection.getClass().getComponentType(), size));
        BookshelfGameTests.testFrom(functions, bufferHelper, codecHelper, Objects::equals, testArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static <T> void testFrom(Collection<TestFunction> functions, ByteBufHelper<T> bufferHelper, CodecHelper<T> codecHelper, BiPredicate<T, T> equality, T ... collection) {
        String typeName = BookshelfGameTests.toSnakeCase(collection.getClass().getComponentType().getSimpleName());
        if (codecHelper instanceof RegistryCodecHelper) {
            RegistryCodecHelper registryCodecHelper = (RegistryCodecHelper)codecHelper;
            if (bufferHelper instanceof RegistryByteBufHelper) {
                RegistryByteBufHelper registryBufHelper = (RegistryByteBufHelper)bufferHelper;
                ResourceLocation registryId = registryCodecHelper.getRegistry().key().location();
                String registryTypeName = registryId.getNamespace() + "_" + registryId.getPath();
                A[] testArray = registryCodecHelper.getRegistry().stream().limit(5L).toArray(size -> (Object[])Array.newInstance(collection.getClass().getComponentType(), size));
                TagKey[] tagExamples = new TagKey[]{TagKey.create((ResourceKey)registryCodecHelper.getRegistry().key(), (ResourceLocation)Constants.id("test_one")), TagKey.create((ResourceKey)registryCodecHelper.getRegistry().key(), (ResourceLocation)Constants.id("test_two")), TagKey.create((ResourceKey)registryCodecHelper.getRegistry().key(), (ResourceLocation)new ResourceLocation("test_three"))};
                BookshelfGameTests.testFrom(functions, new RegistryCodecTests("registry_" + registryTypeName, registryCodecHelper, testArray));
                BookshelfGameTests.testFrom(functions, new ByteBufTests("registry_" + registryTypeName, registryBufHelper, testArray));
                BookshelfGameTests.testFrom(functions, new CodecTests<TagKey>("tags_" + registryTypeName, registryCodecHelper.tag(), tagExamples));
                BookshelfGameTests.testFrom(functions, new ByteBufTests<TagKey>("tags_" + registryTypeName, registryBufHelper.tag(), tagExamples));
                return;
            }
        }
        BookshelfGameTests.testFrom(functions, new CodecTests<T>(typeName, codecHelper, equality, collection));
        BookshelfGameTests.testFrom(functions, new ByteBufTests<T>(typeName, bufferHelper, equality, collection));
    }

    public static <T> void testFrom(Collection<TestFunction> functions, T testImpl) {
        String string;
        if (testImpl instanceof ITestable) {
            ITestable testObj = (ITestable)testImpl;
            string = testObj.getDefaultBatch();
        } else {
            string = null;
        }
        String parentBatch = string;
        for (Method method : testImpl.getClass().getMethods()) {
            if (!method.isAnnotationPresent(GameTest.class)) continue;
            GameTest annotation = method.getAnnotation(GameTest.class);
            String template = annotation.template().isEmpty() ? "bookshelf:empty" : annotation.template();
            String batch = parentBatch != null && annotation.batch().equalsIgnoreCase("defaultBatch") ? parentBatch : annotation.batch();
            String testName = batch + "." + CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, method.getName());
            Rotation rotation = StructureUtils.getRotationForRotationSteps((int)annotation.rotationSteps());
            functions.add(new TestFunction(batch, testName, template, rotation, annotation.timeoutTicks(), annotation.setupTicks(), annotation.required(), annotation.requiredSuccesses(), annotation.attempts(), gameTestHelper -> {
                try {
                    method.invoke(testImpl, gameTestHelper);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Failed to invoke test method (%s) in (%s) because %s".formatted(method.getName(), method.getDeclaringClass().getCanonicalName(), e.getMessage()), e);
                }
                catch (InvocationTargetException e) {
                    RuntimeException runtimeException;
                    Throwable throwable = e.getCause();
                    RuntimeException rte = throwable instanceof RuntimeException ? (runtimeException = (RuntimeException)throwable) : new RuntimeException(e.getCause());
                    Constants.LOG.error("The test {} failed to run!", (Object)testName, (Object)e);
                    throw rte;
                }
            }));
        }
    }

    private static ItemStack[] getTestStacks() {
        return new ItemStack[]{new ItemStack((ItemLike)Items.STONE), new ItemStack((ItemLike)Items.STICK).setHoverName((Component)Component.literal((String)"test")), new ItemStack((ItemLike)Items.STONE_AXE), ItemStack.EMPTY, new ItemStackBuilder((ItemLike)Items.GLOW_ITEM_FRAME).enchant(Enchantments.ALL_DAMAGE_PROTECTION).build(), new ItemStackBuilder((ItemLike)Items.BOOKSHELF).name((Component)Component.literal((String)"HELP")).lore(new Component[]{Component.literal((String)"hello world")}).build()};
    }

    private static CompoundTag[] getTestTags() {
        CompoundTag tag1 = new CompoundTag();
        CompoundTag tag2 = new CompoundTag();
        tag2.put("one", (Tag)IntTag.valueOf((int)33));
        tag2.put("two", (Tag)StringTag.valueOf((String)"hello"));
        CompoundTag tag3 = new CompoundTag();
        tag3.put("one", (Tag)tag2);
        tag3.put("two", (Tag)new ListTag());
        return new CompoundTag[]{tag1, tag2, tag3};
    }

    private static String toSnakeCase(String str) {
        if (StringUtils.isAllUpperCase((CharSequence)str) || StringUtils.isAllLowerCase((CharSequence)str)) {
            return str.toLowerCase(Locale.ROOT);
        }
        StringBuilder result = new StringBuilder();
        result.append(Character.toLowerCase(str.charAt(0)));
        for (int i = 1; i < str.length(); ++i) {
            char ch = str.charAt(i);
            result.append(Character.isUpperCase(ch) ? "_" + Character.toLowerCase(ch) : Character.valueOf(ch));
        }
        return result.toString();
    }
}

