/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.data.codecs;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.darkhax.bookshelf.api.data.codecs.BookshelfCodecs;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;

public class CodecHelper<T> {
    private final Codec<T> elementCodec;
    private final IntFunction<T[]> arrayBuilder;

    public CodecHelper(Codec<T> elementCodec, T ... vargs) {
        if (vargs.length > 0) {
            throw new IllegalArgumentException("The arrayBuilder must be empty!");
        }
        this.elementCodec = elementCodec;
        this.arrayBuilder = size -> (Object[])Array.newInstance(vargs.getClass().getComponentType(), size);
    }

    public Codec<T> get() {
        return this.elementCodec;
    }

    public <O> RecordCodecBuilder<O, T> get(String fieldName, Function<O, T> getter) {
        return this.get().fieldOf(fieldName).forGetter(getter);
    }

    public <O> RecordCodecBuilder<O, T> get(String fieldName, Function<O, T> getter, T fallback) {
        return this.get().optionalFieldOf(fieldName, fallback).forGetter(getter);
    }

    public Codec<T[]> getArray() {
        return BookshelfCodecs.flexibleArray(this.get(), this.arrayBuilder);
    }

    public <O> RecordCodecBuilder<O, T[]> getArray(String fieldName, Function<O, T[]> getter) {
        return this.getArray().fieldOf(fieldName).forGetter(getter);
    }

    public <O> RecordCodecBuilder<O, T[]> getArray(String fieldName, Function<O, T[]> getter, T ... fallback) {
        return this.getArray().optionalFieldOf(fieldName, fallback).forGetter(getter);
    }

    public Codec<List<T>> getList() {
        return BookshelfCodecs.flexibleList(this.get());
    }

    public <O> RecordCodecBuilder<O, List<T>> getList(String fieldName, Function<O, List<T>> getter) {
        return this.getList().fieldOf(fieldName).forGetter(getter);
    }

    public <O> RecordCodecBuilder<O, List<T>> getList(String fieldName, Function<O, List<T>> getter, List<T> fallback) {
        return this.getList().optionalFieldOf(fieldName, fallback).forGetter(getter);
    }

    public <O> RecordCodecBuilder<O, List<T>> getList(String fieldName, Function<O, List<T>> getter, T ... fallback) {
        return this.getList().optionalFieldOf(fieldName, List.of(fallback)).forGetter(getter);
    }

    public Codec<Set<T>> getSet() {
        return BookshelfCodecs.flexibleSet(this.get());
    }

    public <O> RecordCodecBuilder<O, Set<T>> getSet(String fieldName, Function<O, Set<T>> getter) {
        return this.getSet().fieldOf(fieldName).forGetter(getter);
    }

    public <O> RecordCodecBuilder<O, Set<T>> getSet(String fieldName, Function<O, Set<T>> getter, Set<T> fallback) {
        return this.getSet().optionalFieldOf(fieldName, fallback).forGetter(getter);
    }

    public <O> RecordCodecBuilder<O, Set<T>> getSet(String fieldName, Function<O, Set<T>> getter, T ... fallback) {
        return this.getSet().optionalFieldOf(fieldName, Set.of(fallback)).forGetter(getter);
    }

    public MapCodec<Optional<T>> getOptional(String fieldName) {
        return this.get().optionalFieldOf(fieldName);
    }

    public <O> RecordCodecBuilder<O, Optional<T>> getOptional(String fieldName, Function<O, Optional<T>> getter) {
        return this.get().optionalFieldOf(fieldName).forGetter(getter);
    }

    public <O> RecordCodecBuilder<O, Optional<T>> getOptional(String fieldName, Function<O, Optional<T>> getter, Optional<T> fallback) {
        return BookshelfCodecs.optional(this.get(), fieldName, fallback, true).forGetter(getter);
    }

    public MapCodec<T> getNullable(String fieldName) {
        return BookshelfCodecs.nullable(this.get(), fieldName);
    }

    public <O> RecordCodecBuilder<O, T> getNullable(String fieldName, Function<O, T> getter) {
        return this.getNullable(fieldName).forGetter(getter);
    }

    public Codec<WeightedEntry.Wrapper<T>> getWeighted() {
        return WeightedEntry.Wrapper.codec(this.get());
    }

    public <O> RecordCodecBuilder<O, WeightedEntry.Wrapper<T>> getWeighted(String fieldName, Function<O, WeightedEntry.Wrapper<T>> getter) {
        return WeightedEntry.Wrapper.codec(this.get()).fieldOf(fieldName).forGetter(getter);
    }

    public Codec<SimpleWeightedRandomList<T>> getWeightedList() {
        return SimpleWeightedRandomList.wrappedCodec(this.get());
    }

    public <O> RecordCodecBuilder<O, SimpleWeightedRandomList<T>> getWeightedList(String fieldName, Function<O, SimpleWeightedRandomList<T>> getter) {
        return this.getWeightedList().fieldOf(fieldName).forGetter(getter);
    }
}

