/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.Arrays;
import java.util.Objects;
import net.darkhax.bookshelf.api.util.AttributeHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public final class ItemStackHelper {
    public static double getAttackDamage(ItemStack stack) {
        return ItemStackHelper.getAttackDamage(stack, MobType.UNDEFINED);
    }

    public static double getAttackDamage(ItemStack stack, Entity target) {
        MobType mobType;
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            mobType = living.getMobType();
        } else {
            mobType = MobType.UNDEFINED;
        }
        return ItemStackHelper.getAttackDamage(stack, mobType);
    }

    public static double getAttackDamage(ItemStack stack, MobType targetType) {
        double damage = AttributeHelper.getAttackDamage(stack);
        double bonusEnchantmentDamage = EnchantmentHelper.getDamageBonus((ItemStack)stack, (MobType)targetType);
        return damage + bonusEnchantmentDamage;
    }

    public static ItemStack[] getTabItems(CreativeModeTab tab) {
        return (ItemStack[])tab.getDisplayItems().toArray(ItemStack[]::new);
    }

    public static boolean areStacksEquivalent(ItemStack first, ItemStack second) {
        return ItemStackHelper.areStacksEquivalent(first, second, false);
    }

    public static boolean areStacksContentsEquivalent(ItemStack first, ItemStack second) {
        return ItemStackHelper.areStacksEquivalent(first, second, true);
    }

    public static boolean areStacksEquivalent(ItemStack first, ItemStack second, boolean ignoreTags) {
        return first.isEmpty() == second.isEmpty() && first.getCount() == second.getCount() && first.getItem() == second.getItem() && (ignoreTags || Objects.equals(first.getTag(), second.getTag()));
    }

    public static void setLore(ItemStack stack, Component ... lines) {
        CompoundTag displayTag = stack.getOrCreateTagElement("display");
        ListTag loreList = new ListTag();
        Arrays.stream(lines).forEach(line -> loreList.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)line))));
        displayTag.put("Lore", (Tag)loreList);
    }

    public static void appendLore(ItemStack stack, Component ... lines) {
        CompoundTag displayTag = stack.getOrCreateTagElement("display");
        ListTag loreList = displayTag.contains("Lore") ? displayTag.getList("Lore", 8) : new ListTag();
        Arrays.stream(lines).forEach(line -> loreList.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)line))));
        displayTag.put("Lore", (Tag)loreList);
    }
}

