/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.api.util.MathsHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public final class EntityHelper {
    private static final Map<EntityType<?>, Tuple<Integer, Integer>> eggColorCache = new HashMap();

    public static double getDistanceFromEntity(Entity firstEntity, Entity secondEntity) {
        return MathsHelper.getDistanceBetweenPoints(firstEntity.position(), secondEntity.position());
    }

    public static double getDistaceFromPos(Entity entity, BlockPos pos) {
        return MathsHelper.getDistanceBetweenPoints(entity.position(), Vec3.atCenterOf((Vec3i)pos));
    }

    public static void pushTowards(Entity entityToMove, Direction direction, double force) {
        EntityHelper.pushTowards(entityToMove, entityToMove.blockPosition().relative(direction.getOpposite(), 1), force);
    }

    public static void pushTowards(Entity entityToMove, BlockPos pos, double force) {
        double distanceZ;
        double distanceY;
        BlockPos entityPos = entityToMove.blockPosition();
        double distanceX = (double)pos.getX() - (double)entityPos.getX();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)pos.getY() - (double)entityPos.getY()) * distanceY + (distanceZ = (double)pos.getZ() - (double)entityPos.getZ()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.setDeltaMovement(new Vec3(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static void pushTowards(Entity entityToMove, Entity destination, double force) {
        double distanceZ;
        double distanceY;
        double distanceX = destination.getX() - entityToMove.getX();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = destination.getY() - entityToMove.getY()) * distanceY + (distanceZ = destination.getZ() - entityToMove.getZ()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.setDeltaMovement(new Vec3(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static void pushTowardsDirection(Entity entityToMove, Direction direction, double force) {
        double distanceZ;
        double distanceY;
        BlockPos entityPos = entityToMove.blockPosition();
        BlockPos destination = entityToMove.blockPosition().relative(direction.getOpposite(), 1);
        double distanceX = (double)destination.getX() - (double)entityPos.getX();
        double distance = Math.sqrt(distanceX * distanceX + (distanceY = (double)destination.getY() - (double)entityPos.getY()) * distanceY + (distanceZ = (double)destination.getZ() - (double)entityPos.getZ()) * distanceZ);
        if (distance > 0.0) {
            entityToMove.setDeltaMovement(new Vec3(distanceX / distance * force, distanceY / distance * force, distanceZ / distance * force));
        }
    }

    public static boolean areEntitiesCloseEnough(Entity firstEntity, Entity secondEntity, double maxDistance) {
        return EntityHelper.getDistanceFromEntity(firstEntity, secondEntity) < maxDistance * maxDistance;
    }

    public static <T extends Entity> List<T> getEntitiesInArea(Class<T> entityClass, Level world, BlockPos pos, int range) {
        return world.getEntitiesOfClass(entityClass, new AABB(pos.offset(-range, -range, -range), pos.offset(range + 1, range + 1, range + 1)));
    }

    public static boolean isWearingFullSet(Mob living, Class<Item> armorClass) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack armor;
            if (!slot.getType().equals((Object)EquipmentSlot.Type.ARMOR) || !(armor = living.getItemBySlot(slot)).isEmpty() && armor.getItem().getClass().equals(armorClass)) continue;
            return false;
        }
        return true;
    }

    public static HitResult rayTrace(LivingEntity entity, double length, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        Vec3 startingPosition = new Vec3(entity.getX(), entity.getY() + (double)entity.getEyeHeight(), entity.getZ());
        Vec3 lookVector = entity.getLookAngle();
        Vec3 endingPosition = startingPosition.add(lookVector.x * length, lookVector.y * length, lookVector.z * length);
        return entity.level().clip(new ClipContext(startingPosition, endingPosition, blockMode, fluidMode, (Entity)entity));
    }

    public static boolean isAffectedByFire(LivingEntity toCheck) {
        return !toCheck.fireImmune() && !toCheck.hasEffect(MobEffects.FIRE_RESISTANCE);
    }

    public static void clearEffects(LivingEntity entity, boolean removePositive, boolean removeNegative) {
        HashSet<MobEffect> toClear = new HashSet<MobEffect>();
        for (MobEffectInstance mobEffectInstance : entity.getActiveEffects()) {
            boolean isGood = mobEffectInstance.getEffect().isBeneficial();
            if ((!isGood || !removePositive) && (isGood || !removeNegative)) continue;
            toClear.add(mobEffectInstance.getEffect());
        }
        for (MobEffect mobEffect : toClear) {
            entity.removeEffect(mobEffect);
        }
    }

    public static Tuple<Integer, Integer> getEggColors(EntityType<?> type) {
        return eggColorCache.computeIfAbsent(type, key -> {
            SpawnEggItem item = SpawnEggItem.byId((EntityType)key);
            if (item != null) {
                return new Tuple((Object)item.getColor(0), (Object)item.getColor(1));
            }
            return new Tuple((Object)0, (Object)0);
        });
    }
}

