/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class SerializerText
implements ISerializer<Component> {
    public static final ISerializer<Component> SERIALIZER = new SerializerText();

    @Override
    public Component fromJSON(JsonElement json) {
        MutableComponent component = Component.Serializer.fromJson((JsonElement)json);
        if (component == null) {
            throw new JsonParseException("Text can not be null.");
        }
        return component;
    }

    @Override
    public JsonElement toJSON(Component toWrite) {
        return Component.Serializer.toJsonTree((Component)toWrite);
    }

    @Override
    public Component fromByteBuf(FriendlyByteBuf buffer) {
        String jsonString = buffer.readUtf();
        return Component.Serializer.fromJson((String)jsonString);
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, Component toWrite) {
        buffer.writeUtf(Component.Serializer.toJson((Component)toWrite));
    }

    @Override
    public Tag toNBT(Component toWrite) {
        return Serializers.STRING.toNBT(Component.Serializer.toJson((Component)toWrite));
    }

    @Override
    public Component fromNBT(Tag nbt) {
        MutableComponent component = Component.Serializer.fromJson((String)Serializers.STRING.fromNBT(nbt));
        if (component == null) {
            throw new JsonParseException("Text can not be null.");
        }
        return component;
    }
}

