/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.inventory;

import java.util.stream.IntStream;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.darkhax.bookshelf.api.inventory.IInventoryAccess;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;

public class ContainerInventoryAccess<T extends Container>
implements IInventoryAccess {
    protected final T internal;
    private final CachedSupplier<int[]> availableSlots;

    public ContainerInventoryAccess(T internal) {
        this.internal = internal;
        this.availableSlots = CachedSupplier.cache(() -> IntStream.range(0, internal.getContainerSize()).toArray());
    }

    @Override
    public int[] getAvailableSlots(Direction side) {
        return this.availableSlots.get();
    }

    @Override
    public ItemStack getStackInSlot(int slot) {
        return this.internal.getItem(slot);
    }

    @Override
    public ItemStack insert(int slot, ItemStack insertStack, Direction side, boolean modify) {
        return this.insert(slot, insertStack, side, modify, false);
    }

    public ItemStack insert(int slot, ItemStack insertStack, Direction side, boolean modify, boolean forceInsert) {
        if (insertStack.isEmpty() || !forceInsert && !this.isValidForSlot(slot, insertStack, side)) {
            return insertStack;
        }
        ItemStack existingStack = this.internal.getItem(slot);
        if (!existingStack.isEmpty()) {
            if (existingStack.getCount() >= Math.min(existingStack.getMaxStackSize(), this.getSlotSize(slot))) {
                return insertStack;
            }
            if (!Services.INVENTORY_HELPER.canItemsStack(existingStack, insertStack)) {
                return insertStack;
            }
            int availableSpace = Math.min(insertStack.getMaxStackSize(), this.getSlotSize(slot) - existingStack.getCount());
            if (availableSpace < 1) {
                return insertStack;
            }
            if (insertStack.getCount() <= availableSpace) {
                if (modify) {
                    ItemStack replacement = insertStack.copy();
                    replacement.grow(existingStack.getCount());
                    this.updateSlot(slot, replacement);
                }
                return ItemStack.EMPTY;
            }
            ItemStack uninserted = insertStack.copy();
            if (modify) {
                ItemStack replacement = uninserted.split(availableSpace);
                replacement.grow(existingStack.getCount());
                this.updateSlot(slot, replacement);
                return uninserted;
            }
            uninserted.shrink(availableSpace);
            return uninserted;
        }
        int availableSpace = Math.min(insertStack.getMaxStackSize(), this.getSlotSize(slot));
        if (availableSpace < insertStack.getCount()) {
            ItemStack uninserted = insertStack.copy();
            if (modify) {
                this.updateSlot(slot, uninserted.split(availableSpace));
                return uninserted;
            }
            uninserted.shrink(availableSpace);
            return uninserted;
        }
        if (modify) {
            this.updateSlot(slot, insertStack.copy());
        }
        return ItemStack.EMPTY;
    }

    @Override
    public ItemStack extract(int slot, int amount, Direction side, boolean modify) {
        if (amount == 0) {
            return ItemStack.EMPTY;
        }
        ItemStack existingStack = this.internal.getItem(slot);
        if (existingStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (modify) {
            int amountExtracted = Math.min(existingStack.getCount(), amount);
            ItemStack extracted = this.internal.removeItem(slot, amountExtracted);
            this.internal.setChanged();
            return extracted;
        }
        ItemStack extracted = existingStack.copy();
        if (amount < extracted.getCount()) {
            extracted.setCount(amount);
        }
        return extracted;
    }

    @Override
    public int getSlotSize(int slot) {
        return this.internal.getMaxStackSize();
    }

    @Override
    public boolean isValidForSlot(int slot, ItemStack stack, Direction side) {
        return this.internal.canPlaceItem(slot, stack);
    }

    protected void updateSlot(int slot, ItemStack stack) {
        this.internal.setItem(slot, stack);
        this.internal.setChanged();
    }
}

