/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class SerializerCodec<T>
implements ISerializer<T> {
    private final Codec<T> codec;

    public SerializerCodec(Codec<T> codec) {
        this.codec = codec;
    }

    @Override
    public T fromJSON(JsonElement json) {
        return (T)((Pair)this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).result().orElseThrow()).getFirst();
    }

    @Override
    public JsonElement toJSON(T toWrite) {
        return (JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, toWrite).result().orElseThrow();
    }

    @Override
    public T fromByteBuf(FriendlyByteBuf buffer) {
        CompoundTag tag = Serializers.COMPOUND_TAG.fromByteBuf(buffer);
        return this.fromNBT(tag.m_128423_("data"));
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, T toWrite) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("data", this.toNBT(toWrite));
        Serializers.COMPOUND_TAG.toByteBuf(buffer, tag);
    }

    @Override
    public Tag toNBT(T toWrite) {
        return (Tag)this.codec.encodeStart((DynamicOps)NbtOps.f_128958_, toWrite).result().orElseThrow();
    }

    @Override
    public T fromNBT(Tag nbt) {
        return (T)((Pair)this.codec.decode((DynamicOps)NbtOps.f_128958_, (Object)nbt).result().orElseThrow()).getFirst();
    }
}

