/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.darkhax.bookshelf.api.util.TextHelper;
import net.darkhax.bookshelf.impl.commands.args.FontArgument;
import net.darkhax.bookshelf.mixin.block.entity.AccessorSignBlockEntity;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;

public class CommandFont {
    public static LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder font = Commands.m_82127_((String)"font");
        font.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"item").requires(p -> p.m_6761_(2))).then(FontArgument.argument().executes(CommandFont::renameItemWithFont)));
        font.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"block").requires(p -> p.m_6761_(2))).then(FontArgument.argument().then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(CommandFont::renameBlockWithFont))));
        font.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"book").requires(p -> p.m_6761_(2))).then(FontArgument.argument().executes(CommandFont::setBookFont)));
        font.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"say").requires(p -> p.m_6761_(2))).then(FontArgument.argument().then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(CommandFont::speakWithFont))));
        return font;
    }

    private static int speakWithFont(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceLocation fontId = FontArgument.getFont(context);
        Component inputMessage = TextHelper.applyFont(MessageArgument.m_96835_(context, (String)"message"), fontId);
        MutableComponent txtMessage = Component.m_237110_((String)"chat.type.announcement", (Object[])new Object[]{((CommandSourceStack)context.getSource()).m_81357_(), inputMessage});
        ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_215627_((Component)txtMessage, ChatType.f_130599_);
        return 0;
    }

    private static int renameItemWithFont(CommandContext<CommandSourceStack> context) {
        ResourceLocation fontId = FontArgument.getFont(context);
        Entity sender = ((CommandSourceStack)context.getSource()).m_81373_();
        if (sender instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)sender;
            ItemStack stack = living.m_21205_();
            stack.m_41714_(TextHelper.applyFont(stack.m_41786_(), fontId));
            return 1;
        }
        return 0;
    }

    private static int renameBlockWithFont(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81372_();
        ResourceLocation fontId = FontArgument.getFont(context);
        BlockPos pos = BlockPosArgument.m_118242_(context, (String)"pos");
        BlockEntity tile = world.m_7702_(pos);
        if (tile != null) {
            if (tile instanceof BaseContainerBlockEntity) {
                BaseContainerBlockEntity container = (BaseContainerBlockEntity)tile;
                container.m_58638_(TextHelper.applyFont(container.m_7755_(), fontId));
            }
            if (tile instanceof SignBlockEntity) {
                SignBlockEntity sign = (SignBlockEntity)tile;
                for (int i = 0; i < 4; ++i) {
                    Component component = sign.m_155706_(i, false);
                    if (component == null || component == Component.f_130760_) continue;
                    sign.m_59732_(i, TextHelper.applyFont((Component)component.m_6881_(), fontId));
                }
                ((AccessorSignBlockEntity)sign).bookshelf$markUpdated();
            }
        }
        return 1;
    }

    private static int setBookFont(CommandContext<CommandSourceStack> context) {
        LivingEntity living;
        ItemStack stack;
        Item item;
        ResourceLocation fontId = FontArgument.getFont(context);
        Entity sender = ((CommandSourceStack)context.getSource()).m_81373_();
        if (sender instanceof LivingEntity && (item = (stack = (living = (LivingEntity)sender).m_21205_()).m_41720_()) instanceof WrittenBookItem) {
            WrittenBookItem book = (WrittenBookItem)item;
            if (stack.m_41782_()) {
                stack.m_41714_(TextHelper.applyFont(stack.m_41786_(), fontId));
                CompoundTag stackTag = stack.m_41783_();
                if (stackTag != null) {
                    ListTag pageData = stackTag.m_128437_("pages", 8);
                    for (int pageNum = 0; pageNum < pageData.size(); ++pageNum) {
                        MutableComponent pageText = Component.Serializer.m_130714_((String)pageData.m_128778_(pageNum));
                        TextHelper.applyFont((Component)pageText, fontId);
                        pageData.set(pageNum, (Tag)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)pageText)));
                    }
                    stackTag.m_128365_("pages", (Tag)pageData);
                }
                return 1;
            }
        }
        return 0;
    }
}

