/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.joml.Vector4f;

public class SerializerVector4f
implements ISerializer<Vector4f> {
    public static final ISerializer<Vector4f> SERIALIZER = new SerializerVector4f();

    @Override
    public Vector4f fromJSON(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            float x = Serializers.FLOAT.fromJSON(object, "x").floatValue();
            float y = Serializers.FLOAT.fromJSON(object, "y").floatValue();
            float z = Serializers.FLOAT.fromJSON(object, "z").floatValue();
            float w = Serializers.FLOAT.fromJSON(object, "w").floatValue();
            return new Vector4f(x, y, z, w);
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            if (array.size() == 4) {
                return new Vector4f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat(), array.get(3).getAsFloat());
            }
            throw new JsonParseException("Invalid number of args in array. Expected 4 but got " + array.size());
        }
        throw new JsonParseException("Vector4f data is not in a readable format.");
    }

    @Override
    public JsonElement toJSON(Vector4f toWrite) {
        JsonObject object = new JsonObject();
        object.addProperty("x", (Number)Float.valueOf(toWrite.x()));
        object.addProperty("y", (Number)Float.valueOf(toWrite.y()));
        object.addProperty("z", (Number)Float.valueOf(toWrite.z()));
        object.addProperty("w", (Number)Float.valueOf(toWrite.w()));
        return object;
    }

    @Override
    public Vector4f fromByteBuf(class_2540 buffer) {
        return new Vector4f(buffer.readFloat(), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
    }

    @Override
    public void toByteBuf(class_2540 buffer, Vector4f toWrite) {
        buffer.method_52941(toWrite.x());
        buffer.method_52941(toWrite.y());
        buffer.method_52941(toWrite.z());
        buffer.method_52941(toWrite.w());
    }

    @Override
    public class_2520 toNBT(Vector4f toWrite) {
        class_2487 tag = new class_2487();
        tag.method_10548("x", toWrite.x());
        tag.method_10548("y", toWrite.y());
        tag.method_10548("z", toWrite.z());
        tag.method_10548("w", toWrite.w());
        return tag;
    }

    @Override
    public Vector4f fromNBT(class_2520 nbt) {
        if (nbt instanceof class_2487) {
            class_2487 compound = (class_2487)nbt;
            float x = compound.method_10583("x");
            float y = compound.method_10583("y");
            float z = compound.method_10583("z");
            float w = compound.method_10583("w");
            return new Vector4f(x, y, z, w);
        }
        if (nbt instanceof class_2499) {
            class_2499 list = (class_2499)nbt;
            if (list.size() == 4) {
                return new Vector4f(Serializers.FLOAT.fromNBT(list.method_10534(0)).floatValue(), Serializers.FLOAT.fromNBT(list.method_10534(1)).floatValue(), Serializers.FLOAT.fromNBT(list.method_10534(2)).floatValue(), Serializers.FLOAT.fromNBT(list.method_10534(3)).floatValue());
            }
            throw new NBTParseException("Invalid number of args in array. Expected 4 but got " + list.size());
        }
        throw new NBTParseException("Vector4f data is not in a readable format.");
    }
}

