/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class SerializerBlockPos
implements ISerializer<class_2338> {
    public static final ISerializer<class_2338> SERIALIZER = new SerializerBlockPos();

    @Override
    public class_2338 fromJSON(JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject object = json.getAsJsonObject();
            int x = Serializers.INT.fromJSON(object, "x");
            int y = Serializers.INT.fromJSON(object, "y");
            int z = Serializers.INT.fromJSON(object, "z");
            return new class_2338(x, y, z);
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            if (array.size() == 3) {
                return new class_2338(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt());
            }
            throw new JsonParseException("Invalid number of args in array. Expected 3 but got " + array.size());
        }
        if (json.isJsonPrimitive()) {
            JsonPrimitive primitive = json.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return class_2338.method_10092((long)json.getAsLong());
            }
            throw new JsonParseException("Expected JSON primitive to be a number.");
        }
        throw new JsonParseException("BlockPos data is not in a readable format.");
    }

    @Override
    public JsonElement toJSON(class_2338 toWrite) {
        JsonObject object = new JsonObject();
        object.addProperty("x", (Number)toWrite.method_10263());
        object.addProperty("y", (Number)toWrite.method_10264());
        object.addProperty("z", (Number)toWrite.method_10260());
        return object;
    }

    @Override
    public class_2338 fromByteBuf(class_2540 buffer) {
        return class_2338.method_10092((long)buffer.readLong());
    }

    @Override
    public void toByteBuf(class_2540 buffer, class_2338 toWrite) {
        buffer.method_52974(toWrite.method_10063());
    }

    @Override
    public class_2520 toNBT(class_2338 toWrite) {
        class_2487 tag = new class_2487();
        tag.method_10569("x", toWrite.method_10263());
        tag.method_10569("y", toWrite.method_10264());
        tag.method_10569("z", toWrite.method_10260());
        return tag;
    }

    @Override
    public class_2338 fromNBT(class_2520 nbt) {
        if (nbt instanceof class_2487) {
            class_2487 compound = (class_2487)nbt;
            int x = compound.method_10550("x");
            int y = compound.method_10550("y");
            int z = compound.method_10550("z");
            return new class_2338(x, y, z);
        }
        if (nbt instanceof class_2499) {
            class_2499 list = (class_2499)nbt;
            if (list.size() == 3) {
                return new class_2338(Serializers.INT.fromNBT(list.method_10534(0)).intValue(), Serializers.INT.fromNBT(list.method_10534(1)).intValue(), Serializers.INT.fromNBT(list.method_10534(2)).intValue());
            }
            throw new NBTParseException("Invalid number of args in array. Expected 3 but got " + list.size());
        }
        if (nbt instanceof class_2514) {
            class_2514 numberTag = (class_2514)nbt;
            return class_2338.method_10092((long)numberTag.method_10699());
        }
        throw new NBTParseException("BlockPos data is not in a readable format.");
    }
}

