/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.api.entity.merchant.MerchantTier;
import net.minecraft.class_3852;
import net.minecraft.class_3853;

public class VillagerTradeEntries {
    private final Map<class_3852, Multimap<Integer, class_3853.class_1652>> villagerTrades = new HashMap<class_3852, Multimap<Integer, class_3853.class_1652>>();
    private final List<class_3853.class_1652> rareTrades = new ArrayList<class_3853.class_1652>();
    private final List<class_3853.class_1652> commonTrades = new ArrayList<class_3853.class_1652>();

    public void addTrade(class_3852 profession, int tier, class_3853.class_1652 trade) {
        this.villagerTrades.computeIfAbsent(profession, p -> ArrayListMultimap.create()).put((Object)tier, (Object)trade);
    }

    public void addTrade(class_3852 profession, MerchantTier tier, class_3853.class_1652 trade) {
        this.addTrade(profession, tier.ordinal() + 1, trade);
    }

    public void addWanderingTrade(class_3853.class_1652 trade, boolean isRare) {
        (isRare ? this.rareTrades : this.commonTrades).add(trade);
    }

    public void addRareWanderingTrade(class_3853.class_1652 trade) {
        this.addWanderingTrade(trade, true);
    }

    public void addCommonWanderingTrade(class_3853.class_1652 trade) {
        this.addWanderingTrade(trade, false);
    }

    public Map<class_3852, Multimap<Integer, class_3853.class_1652>> getVillagerTrades() {
        return this.villagerTrades;
    }

    public List<class_3853.class_1652> getRareWanderingTrades() {
        return this.rareTrades;
    }

    public List<class_3853.class_1652> getCommonWanderingTrades() {
        return this.commonTrades;
    }
}

