/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.mixin.accessors.item.crafting.AccessorShapedRecipe;
import net.darkhax.bookshelf.mixin.accessors.item.crafting.AccessorShapedRecipeSerializer;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_5699;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import net.minecraft.class_8785;
import org.apache.commons.lang3.NotImplementedException;

public final class ShapedDurabilityRecipe
extends class_1869 {
    public static final Serializer SERIALIZER = new Serializer();
    private final int damageAmount;
    private final class_1799 output;

    public ShapedDurabilityRecipe(String group, class_7710 category, int width, int height, class_2371<class_1856> input, class_1799 output, boolean showNotification, int damageAmount) {
        super(group, category, width, height, input, output, showNotification);
        this.damageAmount = damageAmount;
        this.output = output;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_2371<class_1799> getRemainingItems(class_8566 inv) {
        class_2371 keptItems = super.method_8111((class_1263)inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, (class_2371<class_1799>)keptItems, this.damageAmount);
    }

    public static final class Serializer
    implements class_1865<ShapedDurabilityRecipe> {
        public static final Codec<ShapedDurabilityRecipe> CODEC = RawData.CODEC.flatXmap(rawData -> {
            String[] pattern = AccessorShapedRecipe.bookshelf$shrink(rawData.pattern);
            int recipeWidth = pattern[0].length();
            int recipeHeight = pattern.length;
            class_2371 inputGrid = class_2371.method_10213((int)(recipeWidth * recipeHeight), (Object)class_1856.field_9017);
            HashSet unresolvedKeys = Sets.newHashSet(rawData.keys.keySet());
            for (int x = 0; x < pattern.length; ++x) {
                String patternRow = pattern[x];
                for (int y = 0; y < patternRow.length(); ++y) {
                    class_1856 matchingIngredient;
                    String patternKey = patternRow.substring(y, y + 1);
                    class_1856 class_18562 = matchingIngredient = patternKey.equals(" ") ? class_1856.field_9017 : rawData.keys.get(patternKey);
                    if (matchingIngredient == null) {
                        return DataResult.error(() -> "Pattern references symbol '" + patternKey + "' but it's not defined in the key");
                    }
                    unresolvedKeys.remove(patternKey);
                    inputGrid.set(y + recipeWidth * x, (Object)matchingIngredient);
                }
            }
            if (!unresolvedKeys.isEmpty()) {
                return DataResult.error(() -> "Key defines symbols that aren't used in pattern: " + unresolvedKeys);
            }
            return DataResult.success((Object)((Object)new ShapedDurabilityRecipe(rawData.group, rawData.category, recipeWidth, recipeHeight, (class_2371<class_1856>)inputGrid, rawData.result, rawData.showNotification, rawData.damageAmount)));
        }, data -> {
            throw new NotImplementedException("Serializing ShapedRecipe is not implemented yet.");
        });

        public Codec<ShapedDurabilityRecipe> method_53736() {
            return CODEC;
        }

        public ShapedDurabilityRecipe fromNetwork(class_2540 buffer) {
            int width = buffer.readInt();
            int height = buffer.readInt();
            String group = buffer.method_19772();
            class_2371 input = class_2371.method_10213((int)(width * height), (Object)class_1856.field_9017);
            for (int i = 0; i < input.size(); ++i) {
                input.set(i, (Object)class_1856.method_8086((class_2540)buffer));
            }
            class_1799 output = buffer.method_10819();
            boolean showNotification = buffer.readBoolean();
            int damageAmount = buffer.readInt();
            class_7710 category = (class_7710)buffer.method_10818(class_7710.class);
            return new ShapedDurabilityRecipe(group, category, width, height, (class_2371<class_1856>)input, output, showNotification, damageAmount);
        }

        public void toNetwork(class_2540 buffer, ShapedDurabilityRecipe recipe) {
            buffer.method_53002(recipe.method_8150());
            buffer.method_53002(recipe.method_8158());
            buffer.method_10814(recipe.method_8112());
            for (class_1856 ingredient : recipe.method_8117()) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.output);
            buffer.method_52964(recipe.method_49188());
            buffer.method_53002(recipe.damageAmount);
            buffer.method_10817((Enum)recipe.method_45441());
        }

        private record RawData(String group, class_7710 category, Map<String, class_1856> keys, List<String> pattern, class_1799 result, boolean showNotification, int damageAmount) {
            public static final Codec<RawData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.method_53049((Codec)Codec.STRING, (String)"group", (Object)"").forGetter(RawData::group), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(RawData::category), (App)class_5699.method_53703(AccessorShapedRecipeSerializer.bookshelf$getSingleCharacterStringCodec(), (Codec)class_1856.field_46096).fieldOf("key").forGetter(RawData::keys), (App)AccessorShapedRecipeSerializer.bookshelf$getPatternCodec().fieldOf("pattern").forGetter(RawData::pattern), (App)class_8785.field_46092.fieldOf("results").forGetter(RawData::result), (App)class_5699.method_53049((Codec)Codec.BOOL, (String)"show_notification", (Object)true).forGetter(RawData::showNotification), (App)Codec.INT.fieldOf("damageAmount").orElse((Object)1).forGetter(RawData::damageAmount)).apply((Applicative)instance, RawData::new));
        }
    }
}

