/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.minecraft.class_2494;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public final class SerializerFloat
implements ISerializer<Float> {
    public static final ISerializer<Float> SERIALIZER = new SerializerFloat();

    private SerializerFloat() {
    }

    @Override
    public Float fromJSON(JsonElement json) {
        return Float.valueOf(json.getAsFloat());
    }

    @Override
    public JsonElement toJSON(Float toWrite) {
        return new JsonPrimitive((Number)toWrite);
    }

    @Override
    public Float fromByteBuf(class_2540 buffer) {
        return Float.valueOf(buffer.readFloat());
    }

    @Override
    public void toByteBuf(class_2540 buffer, Float toWrite) {
        buffer.method_52941(toWrite.floatValue());
    }

    @Override
    public class_2520 toNBT(Float toWrite) {
        return class_2494.method_23244((float)toWrite.floatValue());
    }

    @Override
    public Float fromNBT(class_2520 nbt) {
        if (nbt instanceof class_2514) {
            class_2514 floatTag = (class_2514)nbt;
            return Float.valueOf(floatTag.method_10700());
        }
        throw new NBTParseException("Expected NBT to be a number tag. Class was " + nbt.getClass() + " with ID " + nbt.method_10711() + " instead.");
    }
}

