package net.darkhax.bookshelf.mixin.patches.loot;

import net.darkhax.bookshelf.api.data.BookshelfTags;
import net.minecraft.class_1282;
import net.minecraft.class_181;
import net.minecraft.class_221;
import net.minecraft.class_47;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_221.class)
public class MixinLootItemKilledByPlayerCondition {

    /**
     * This patch allows mobs that were killed with Bookshelfs fake player damage to satisfy the
     * minecraft:killed_by_player loot condition.
     */
    @Inject(method = "test(Lnet/minecraft/world/level/storage/loot/LootContext;)Z", at = @At("HEAD"), cancellable = true)
    public void test(class_47 context, CallbackInfoReturnable<Boolean> callback) {
        if (context != null && context.method_300(class_181.field_1231)) {
            final class_1282 source = context.method_35508(class_181.field_1231);
            if (source != null && source.method_48789(BookshelfTags.DamageTypes.FAKE_PLAYER)) {
                callback.setReturnValue(true);
            }
        }
    }
}