package net.darkhax.bookshelf.impl.util;

import net.darkhax.bookshelf.api.item.tab.IDisplayGenerator;
import net.darkhax.bookshelf.api.item.tab.IOutputWrapper;
import net.darkhax.bookshelf.api.util.IConstructHelper;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3917;
import org.apache.commons.lang3.function.TriFunction;

import java.util.function.BiFunction;
import java.util.function.Supplier;

public class ConstructBuilderFabric implements IConstructHelper {

    @Override
    public <T extends class_2586> Supplier<class_2591<T>> blockEntityType(BiFunction<class_2338, class_2680, T> factory, class_2248... validBlocks) {

        return () -> FabricBlockEntityTypeBuilder.create(factory::apply, validBlocks).build();
    }

    @Override
    public <T extends class_1703> class_3917<T> menuType(TriFunction<Integer, class_1661, class_2540, T> constructor) {

        return new ExtendedScreenHandlerType<>(constructor::apply);
    }

    @Override
    public class_1761.class_7914 wrapDisplayGen(IDisplayGenerator displayGen) {

        return (flags, output) -> displayGen.display(flags, new IOutputWrapper() {
            @Override
            public void accept(class_1799 stack) {
                output.method_45420(stack);
            }

            @Override
            public void accept(class_1935 item) {
                output.method_45421(item);
            }
        });
    }
}