package net.darkhax.bookshelf.impl.resources;

import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

/**
 * Fabric requires modded reload listeners to implement their IdentifiableResourceReloadListener interface. This
 * implementation simply wraps a vanilla compliant reload listener to make it compliant with the Fabric API.
 */
public record WrappedReloadListener(class_2960 id, class_3302 reloadListener) implements IdentifiableResourceReloadListener {

    @Override
    public class_2960 getFabricId() {

        return this.id;
    }

    @Override
    public CompletableFuture<Void> method_25931(class_4045 preparationBarrier, class_3300 resourceManager, class_3695 profilerFiller, class_3695 profilerFiller2, Executor executor, Executor executor2) {

        return reloadListener.method_25931(preparationBarrier, resourceManager, profilerFiller, profilerFiller2, executor, executor2);
    }
}