package net.darkhax.bookshelf.impl.event;

import com.google.common.collect.Multimap;
import net.darkhax.bookshelf.api.event.item.IItemAttributeEvent;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import java.util.Collection;

public class FabricItemAttributeEvent implements IItemAttributeEvent {

    private final class_1799 stack;
    private final class_1304 slotType;
    private final Multimap<class_1320, class_1322> modifiers;

    public FabricItemAttributeEvent(class_1799 stack, class_1304 slotType, Multimap<class_1320, class_1322> originalModifiers) {

        this.stack = stack;
        this.slotType = slotType;
        this.modifiers = originalModifiers;
    }

    @Override
    public boolean addModifier(class_1320 attribute, class_1322 modifier) {
        return this.modifiers.put(attribute, modifier);
    }

    @Override
    public boolean removeModifier(class_1320 attribute, class_1322 modifier) {
        return this.modifiers.remove(attribute, modifier);
    }

    @Override
    public Collection<class_1322> removeAttribute(class_1320 attribute) {
        return this.modifiers.removeAll(attribute);
    }

    @Override
    public void clearModifiers() {
        this.modifiers.clear();
    }

    @Override
    public class_1304 getSlotType() {
        return this.slotType;
    }

    @Override
    public class_1799 getItemStack() {
        return this.stack;
    }
}