package net.darkhax.bookshelf.api.util;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;

/**
 * This class contains static helper methods for working with ItemStacks.
 */
public final class ItemStackHelper {

    /**
     * Calculates the attack damage for an ItemStack when used to attack an unspecified mob. This will include bonus
     * damage sources such as modifiers and enchantments.
     *
     * @param stack The ItemStack to calculate the damage value of.
     * @return The attack damage for an ItemStack with bonus damage modifiers applied.
     */
    public static double getAttackDamage(class_1799 stack) {

        return getAttackDamage(stack, class_1310.field_6290);
    }

    /**
     * Calculates the attack damage for an ItemStack when used to attack a specific entity. This will include bonus
     * damage sources such as attribute modifiers and enchantments.
     *
     * @param stack  The ItemStack to calculate the damage value of.
     * @param target The target entity being attacked.
     * @return The attack damage for an ItemStack with bonus damage modifiers applied.
     */
    public static double getAttackDamage(class_1799 stack, class_1297 target) {

        return getAttackDamage(stack, (target instanceof class_1309 living) ? living.method_6046() : class_1310.field_6290);
    }

    /**
     * Calculates the attack damage for an ItemStack after accounting for bonus damage modifiers such as attribute
     * modifiers and enchantments.
     *
     * @param stack      The ItemStack to calculate the damage value of.
     * @param targetType The type of mob being attacked. Used for some enchantment calculations.
     * @return The attack damage for an ItemStack with bonus damage modifiers applied.
     */
    public static double getAttackDamage(class_1799 stack, class_1310 targetType) {

        final double damage = AttributeHelper.getAttackDamage(stack);
        final double bonusEnchantmentDamage = class_1890.method_8218(stack, targetType);

        return damage + bonusEnchantmentDamage;
    }

    public static class_1799[] getTabItems(class_1761 tab) {

        return tab.method_47313().toArray(class_1799[]::new);
    }

    public static boolean areStacksEquivalent(class_1799 first, class_1799 second) {

        return areStacksEquivalent(first, second, false);
    }

    public static boolean areStacksContentsEquivalent(class_1799 first, class_1799 second) {

        return areStacksEquivalent(first, second, true);
    }

    public static boolean areStacksEquivalent(class_1799 first, class_1799 second, boolean ignoreTags) {

        return first.method_7960() == second.method_7960() && first.method_7947() == second.method_7947() && first.method_7909() == second.method_7909() && (ignoreTags || Objects.equals(first.method_7969(), second.method_7969()));
    }

    public static void setLore(class_1799 stack, class_2561... lines) {

        final class_2487 displayTag = stack.method_7911("display");
        final class_2499 loreList = new class_2499();
        Arrays.stream(lines).forEach(line -> loreList.add(class_2519.method_23256(class_2561.class_2562.method_10867(line))));
        displayTag.method_10566("Lore", loreList);
    }

    public static void appendLore(class_1799 stack, class_2561... lines) {

        final class_2487 displayTag = stack.method_7911("display");
        final class_2499 loreList = displayTag.method_10545("Lore") ? displayTag.method_10554("Lore", class_2520.field_33258) : new class_2499();
        Arrays.stream(lines).forEach(line -> loreList.add(class_2519.method_23256(class_2561.class_2562.method_10867(line))));
        displayTag.method_10566("Lore", loreList);
    }
}