package net.darkhax.bookshelf.api.serialization;

import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.sound.Sound;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1535;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1842;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2396;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3784;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.joml.Vector3f;
import org.joml.Vector4f;

import java.util.UUID;

public final class Serializers {

    // JAVA TYPES
    public static final ISerializer<Boolean> BOOLEAN = SerializerBoolean.SERIALIZER;
    public static final ISerializer<Byte> BYTE = SerializerByte.SERIALIZER;
    public static final ISerializer<Short> SHORT = SerializerShort.SERIALIZER;
    public static final ISerializer<Integer> INT = SerializerInteger.SERIALIZER;
    public static final ISerializer<Long> LONG = SerializerLong.SERIALIZER;
    public static final ISerializer<Float> FLOAT = SerializerFloat.SERIALIZER;
    public static final ISerializer<Double> DOUBLE = SerializerDouble.SERIALIZER;
    public static final ISerializer<String> STRING = SerializerString.SERIALIZER;
    public static final ISerializer<UUID> UUID = SerializerUUID.SERIALIZER;

    // MINECRAFT TYPES
    public static final ISerializer<class_2960> RESOURCE_LOCATION = SerializerResourceLocation.SERIALIZER;
    public static final ISerializer<class_1799> ITEM_STACK = SerializerItemStack.SERIALIZER;
    public static final ISerializer<class_2487> COMPOUND_TAG = SerializerCompoundTag.SERIALIZER;
    public static final ISerializer<class_2561> TEXT = SerializerText.SERIALIZER;
    public static final ISerializer<class_2338> BLOCK_POS = SerializerBlockPos.SERIALIZER;
    public static final ISerializer<class_1856> INGREDIENT = SerializerIngredient.SERIALIZER;
    public static final ISerializer<class_2680> BLOCK_STATE = SerializerBlockState.SERIALIZER;
    public static final ISerializer<class_1322> ATTRIBUTE_MODIFIER = SerializerAttributeModifier.SERIALIZER;
    public static final ISerializer<class_1293> EFFECT_INSTANCE = new SerializerEffectInstance();
    public static final ISerializer<class_1889> ENCHANTMENT_INSTANCE = SerializerEnchantmentInstance.SERIALIZER;
    public static final ISerializer<Vector3f> VECTOR_3F = SerializerVector3f.SERIALIZER;
    public static final ISerializer<Vector4f> VECTOR_4F = SerializerVector4f.SERIALIZER;
    public static final ISerializer<Sound> SOUND = Sound.SERIALIZER;
    public static final ISerializer<class_3784> STRUCTURE_POOL_ELEMENT = new SerializerCodec<>(class_3784.field_24953);

    // ENUMS
    public static final ISerializer<class_1814> ITEM_RARITY = new SerializerEnum<>(class_1814.class);
    public static final ISerializer<class_1887.class_1888> ENCHANTMENT_RARITY = new SerializerEnum<>(class_1887.class_1888.class);
    public static final ISerializer<class_1322.class_1323> ATTRIBUTE_OPERATION = new SerializerEnum<>(class_1322.class_1323.class);
    public static final ISerializer<class_2350> DIRECTION = new SerializerEnum<>(class_2350.class);
    public static final ISerializer<class_2350.class_2351> AXIS = new SerializerEnum<>(class_2350.class_2351.class);
    public static final ISerializer<class_2350.class_2353> PLANE = new SerializerEnum<>(class_2350.class_2353.class);
    public static final ISerializer<class_1311> MOB_CATEGORY = new SerializerEnum<>(class_1311.class);
    public static final ISerializer<class_1886> ENCHANTMENT_CATEGORY = new SerializerEnum<>(class_1886.class);
    public static final ISerializer<class_1767> DYE_COLOR = new SerializerEnum<>(class_1767.class);
    public static final ISerializer<class_3419> SOUND_CATEGORY = new SerializerEnum<>(class_3419.class);

    // REGISTRY TYPES
    public static final ISerializer<class_2248> BLOCK = new SerializerRegistryEntry<>(class_7923.field_41175);
    public static final ISerializer<class_1792> ITEM = new SerializerRegistryEntry<>(class_7923.field_41178);
    public static final ISerializer<class_2582> BANNER_PATTERN = new SerializerRegistryEntry<>(class_7923.field_41165);
    public static final ISerializer<class_1887> ENCHANTMENT = new SerializerRegistryEntry<>(class_7923.field_41176);
    public static final ISerializer<class_1535> PAINTING = new SerializerRegistryEntry<>(class_7923.field_41182);
    public static final ISerializer<class_1291> MOB_EFFECT = new SerializerRegistryEntry<>(class_7923.field_41174);
    public static final ISerializer<class_1842> POTION = new SerializerRegistryEntry<>(class_7923.field_41179);
    public static final ISerializer<class_1320> ATTRIBUTE = new SerializerRegistryEntry<>(class_7923.field_41190);
    public static final ISerializer<class_3852> VILLAGER_PROFESSION = new SerializerRegistryEntry<>(class_7923.field_41195);
    public static final ISerializer<class_3854> VILLAGER_TYPE = new SerializerRegistryEntry<>(class_7923.field_41194);
    public static final ISerializer<class_3414> SOUND_EVENT = new SerializerRegistryEntry<>(class_7923.field_41172);
    public static final ISerializer<class_3917<?>> MENU = new SerializerRegistryEntry<>(class_7923.field_41187);
    public static final ISerializer<class_2396<?>> PARTICLE = new SerializerRegistryEntry<>(class_7923.field_41180);
    public static final ISerializer<class_1299<?>> ENTITY = new SerializerRegistryEntry<>(class_7923.field_41177);
    public static final ISerializer<class_2591<?>> BLOCK_ENTITY = new SerializerRegistryEntry<>(class_7923.field_41181);
    public static final ISerializer<class_5712> GAME_EVENT = new SerializerRegistryEntry<>(class_7923.field_41171);

    // Tag Types
    public static final ISerializer<class_6862<class_2248>> BLOCK_TAG = new SerializerTagKey<>(Services.TAGS::blockTag);
    public static final ISerializer<class_6862<class_1792>> ITEM_TAG = new SerializerTagKey<>(Services.TAGS::itemTag);
    public static final ISerializer<class_6862<class_2582>> BANNER_PATTERN_TAG = new SerializerTagKey<>(Services.TAGS::bannerPatternTag);
    public static final ISerializer<class_6862<class_1887>> ENCHANTMENT_TAG = new SerializerTagKey<>(Services.TAGS::enchantmentTag);
    public static final ISerializer<class_6862<class_1535>> MOTIVE_TAG = new SerializerTagKey<>(Services.TAGS::paintingTag);
    public static final ISerializer<class_6862<class_1291>> MOB_EFFECT_TAG = new SerializerTagKey<>(Services.TAGS::effectTag);
    public static final ISerializer<class_6862<class_1842>> POTION_TAG = new SerializerTagKey<>(Services.TAGS::potionTag);
    public static final ISerializer<class_6862<class_1320>> ATTRIBUTE_TAG = new SerializerTagKey<>(Services.TAGS::attributeTag);
    public static final ISerializer<class_6862<class_3852>> VILLAGER_PROFESSION_TAG = new SerializerTagKey<>(Services.TAGS::villagerProfessionTag);
    public static final ISerializer<class_6862<class_3854>> VILLAGER_TYPE_TAG = new SerializerTagKey<>(Services.TAGS::villagerTypeTag);
    public static final ISerializer<class_6862<class_3414>> SOUND_EVENT_TAG = new SerializerTagKey<>(Services.TAGS::soundTag);
    public static final ISerializer<class_6862<class_3917<?>>> MENU_TAG = new SerializerTagKey<>(Services.TAGS::menuTag);
    public static final ISerializer<class_6862<class_2396<?>>> PARTICLE_TAG = new SerializerTagKey<>(Services.TAGS::particleTag);
    public static final ISerializer<class_6862<class_1299<?>>> ENTITY_TAG = new SerializerTagKey<>(Services.TAGS::entityTag);
    public static final ISerializer<class_6862<class_2591<?>>> BLOCK_ENTITY_TAG = new SerializerTagKey<>(Services.TAGS::blockEntityTag);
    public static final ISerializer<class_6862<class_5712>> GAME_EVENT_TAG = new SerializerTagKey<>(Services.TAGS::gameEventTag);
    public static final ISerializer<class_6862<class_3611>> FLUID_TAG = new SerializerTagKey<>(Services.TAGS::fluidTag);
    public static final ISerializer<class_6862<class_2960>> STAT_TAG = new SerializerTagKey<>(Services.TAGS::statTag);
    public static final ISerializer<class_6862<class_3956<?>>> RECIPE_TYPE_TAG = new SerializerTagKey<>(Services.TAGS::recipeTypeTag);
    public static final ISerializer<class_6862<class_1865<?>>> RECIPE_SERIALIZER_TAG = new SerializerTagKey<>(Services.TAGS::recipeSerializerTag);
    public static final ISerializer<class_6862<class_2874>> DIMENSION_TYPE_TAG = new SerializerTagKey<>(Services.TAGS::dimensionTypeTag);
    public static final ISerializer<class_6862<class_1937>> DIMENSION_TAG = new SerializerTagKey<>(Services.TAGS::dimensionTag);
    public static final ISerializer<class_6862<class_1959>> BIOME_TAG = new SerializerTagKey<>(Services.TAGS::biomeTag);
}