package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import java.util.function.Function;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public class SerializerTagKey<T> implements ISerializer<class_6862<T>> {

    private final Function<class_2960, class_6862<T>> tagGetter;

    public SerializerTagKey(Function<class_2960, class_6862<T>> tagGetter) {

        this.tagGetter = tagGetter;
    }

    @Override
    public class_6862<T> fromJSON(JsonElement json) {

        return this.tagGetter.apply(Serializers.RESOURCE_LOCATION.fromJSON(json));
    }

    @Override
    public JsonElement toJSON(class_6862<T> toWrite) {

        return Serializers.RESOURCE_LOCATION.toJSON(toWrite.comp_327());
    }

    @Override
    public class_6862<T> fromByteBuf(class_2540 buffer) {

        return this.tagGetter.apply(Serializers.RESOURCE_LOCATION.fromByteBuf(buffer));
    }

    @Override
    public void toByteBuf(class_2540 buffer, class_6862<T> toWrite) {

        Serializers.RESOURCE_LOCATION.toByteBuf(buffer, toWrite.comp_327());
    }

    @Override
    public class_2520 toNBT(class_6862<T> toWrite) {

        return Serializers.RESOURCE_LOCATION.toNBT(toWrite.comp_327());
    }

    @Override
    public class_6862<T> fromNBT(class_2520 nbt) {

        return this.tagGetter.apply(Serializers.RESOURCE_LOCATION.fromNBT(nbt));
    }
}