package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public final class SerializerString implements ISerializer<String> {

    public static final ISerializer<String> SERIALIZER = new SerializerString();

    private SerializerString() {

    }

    @Override
    public String fromJSON(JsonElement json) {

        return json.getAsString();
    }

    @Override
    public JsonElement toJSON(String toWrite) {

        return new JsonPrimitive(toWrite);
    }

    @Override
    public String fromByteBuf(class_2540 buffer) {

        return buffer.method_19772();
    }

    @Override
    public void toByteBuf(class_2540 buffer, String toWrite) {

        buffer.method_10814(toWrite);
    }

    @Override
    public class_2520 toNBT(String toWrite) {

        return class_2519.method_23256(toWrite);
    }

    @Override
    public String fromNBT(class_2520 nbt) {

        if (nbt instanceof class_2519 stringTag) {

            return stringTag.method_10714();
        }

        throw new NBTParseException("Expected NBT to be a string tag. Class was " + nbt.getClass() + " with ID " + nbt.method_10711() + " instead.");
    }
}