package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1869;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7923;

public class SerializerItemStack implements ISerializer<class_1799> {

    public static final ISerializer<class_1799> SERIALIZER = new SerializerItemStack();

    private SerializerItemStack() {

    }

    @Override
    public class_1799 fromJSON(JsonElement json) {

        if (json instanceof JsonObject obj) {

            // Our code needs to support deserializing air and empty stacks which is not supported by
            // the underlying deserialization code. To avoid this we check and return early.
            final class_2960 identifier = new class_2960(class_3518.method_15265(obj, "item"));

            if (class_7923.field_41178.method_10223(identifier) == class_1802.field_8162) {

                return class_1799.field_8037;
            }

            final class_1799 stack = class_1869.method_35228(obj);

            if (obj.has("nbt") && !stack.method_7985()) {

                stack.method_7980(Serializers.COMPOUND_TAG.fromJSON(obj.get("nbt")));
            }

            return stack;
        }

        else if (json.isJsonPrimitive()) {

            return new class_1799(Serializers.ITEM.fromJSON(json));
        }

        throw new JsonParseException("Expected JSON object, got " + class_3518.method_15266(json));
    }

    @Override
    public JsonElement toJSON(class_1799 toWrite) {

        final JsonObject json = new JsonObject();

        json.add("item", Serializers.ITEM.toJSON(toWrite.method_7909()));
        json.addProperty("count", toWrite.method_7947());

        if (toWrite.method_7985()) {

            json.add("nbt", Serializers.COMPOUND_TAG.toJSON(toWrite.method_7969()));
        }

        return json;
    }

    @Override
    public class_1799 fromByteBuf(class_2540 buffer) {

        return buffer.method_10819();
    }

    @Override
    public void toByteBuf(class_2540 buffer, class_1799 toWrite) {

        buffer.method_10793(toWrite);
    }

    @Override
    public class_2520 toNBT(class_1799 toWrite) {

        return toWrite.method_7953(new class_2487());
    }

    @Override
    public class_1799 fromNBT(class_2520 nbt) {

        if (nbt instanceof class_2487 compound) {

            return class_1799.method_7915(compound);
        }

        else if (nbt instanceof class_2519 string) {

            return new class_1799(Serializers.ITEM.fromNBT(string));
        }

        throw new NBTParseException("Expected NBT to be a compound tag or string. Class was " + nbt.getClass() + " with ID " + nbt.method_10711() + " instead.");
    }
}