package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_2497;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public final class SerializerInteger implements ISerializer<Integer> {

    public static final ISerializer<Integer> SERIALIZER = new SerializerInteger();

    private SerializerInteger() {

    }

    @Override
    public Integer fromJSON(JsonElement json) {

        return json.getAsInt();
    }

    @Override
    public JsonElement toJSON(Integer toWrite) {

        return new JsonPrimitive(toWrite);
    }

    @Override
    public Integer fromByteBuf(class_2540 buffer) {

        return buffer.readInt();
    }

    @Override
    public void toByteBuf(class_2540 buffer, Integer toWrite) {

        buffer.writeInt(toWrite);
    }

    @Override
    public class_2520 toNBT(Integer toWrite) {

        return class_2497.method_23247(toWrite);
    }

    @Override
    public Integer fromNBT(class_2520 nbt) {

        if (nbt instanceof class_2514 intTag) {

            return intTag.method_10701();
        }

        throw new NBTParseException("Expected NBT to be a number tag. Class was " + nbt.getClass() + " with ID " + nbt.method_10711() + " instead.");
    }
}