package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.api.util.JSONHelper;
import net.minecraft.class_2497;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.apache.commons.lang3.EnumUtils;

import java.util.Locale;

public class SerializerEnum<T extends Enum<T>> implements ISerializer<T> {

    public final T defaultValue;
    private final Class<T> enumClass;

    public SerializerEnum(Class<T> enumClass) {

        this(enumClass, null);
    }

    public SerializerEnum(Class<T> enumClass, T defaultValue) {

        this.enumClass = enumClass;
        this.defaultValue = defaultValue;
    }

    @Override
    public T fromJSON(JsonElement json) {

        return this.getByName(JSONHelper.getAsString(json));
    }

    @Override
    public JsonElement toJSON(T toWrite) {

        return new JsonPrimitive(toWrite.name());
    }

    @Override
    public T fromByteBuf(class_2540 buffer) {

        return this.getByName(buffer.method_19772());
    }

    @Override
    public void toByteBuf(class_2540 buffer, T toWrite) {

        buffer.method_10814(toWrite.name());
    }

    @Override
    public class_2520 toNBT(T toWrite) {

        return class_2519.method_23256(toWrite.name());
    }

    @Override
    public T fromNBT(class_2520 nbt) {

        if (nbt instanceof class_2497 integer) {

            return this.getByIndex(integer.method_10701());
        }

        if (nbt instanceof class_2519 stringTag) {

            return this.getByName(stringTag.method_10714());
        }

        throw new NBTParseException("Expected NBT to be a String tag. Class was " + nbt.getClass() + " with ID " + nbt.method_10711() + " instead.");
    }

    private T getByIndex(int index) {

        final T[] values = enumClass.getEnumConstants();

        if (index < 0 || index > values.length) {

            throw new IndexOutOfBoundsException("Cannot read enum by index. Class: " + enumClass.getCanonicalName() + " Index: " + index + " Size: " + values.length);
        }

        return values[index];
    }

    private T getByName(String name) {

        T value = EnumUtils.getEnum(this.enumClass, name);

        if (value == null) {

            value = EnumUtils.getEnum(this.enumClass, name.toUpperCase(Locale.ROOT));
        }

        if (value == null) {

            value = this.defaultValue;
        }

        return value;
    }
}