package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_2481;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public final class SerializerBoolean implements ISerializer<Boolean> {

    public static final ISerializer<Boolean> SERIALIZER = new SerializerBoolean();

    private SerializerBoolean() {

    }

    @Override
    public Boolean fromJSON(JsonElement json) {

        return json.getAsBoolean();
    }

    @Override
    public JsonElement toJSON(Boolean toWrite) {

        return new JsonPrimitive(toWrite);
    }

    @Override
    public Boolean fromByteBuf(class_2540 buffer) {

        return buffer.readBoolean();
    }

    @Override
    public void toByteBuf(class_2540 buffer, Boolean toWrite) {

        buffer.writeBoolean(toWrite);
    }

    @Override
    public class_2520 toNBT(Boolean toWrite) {

        return class_2481.method_23234(toWrite);
    }

    @Override
    public Boolean fromNBT(class_2520 nbt) {

        if (nbt instanceof class_2481 byteTag) {

            return byteTag.method_10698() != 0;
        }

        throw new NBTParseException("Expected NBT to be a byte/boolean tag. Class was " + nbt.getClass() + " with ID " + nbt.method_10711() + " instead.");
    }
}