package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class SerializerBlockPos implements ISerializer<class_2338> {

    public static final ISerializer<class_2338> SERIALIZER = new SerializerBlockPos();

    @Override
    public class_2338 fromJSON(JsonElement json) {

        // If it's an object explicitly read each axis.
        if (json.isJsonObject()) {

            final JsonObject object = json.getAsJsonObject();
            final int x = Serializers.INT.fromJSON(object, "x");
            final int y = Serializers.INT.fromJSON(object, "y");
            final int z = Serializers.INT.fromJSON(object, "z");
            return new class_2338(x, y, z);
        }

        // If it's an array of 3 elements read in X,Y,Z order.
        else if (json.isJsonArray()) {

            final JsonArray array = json.getAsJsonArray();

            if (array.size() == 3) {

                return new class_2338(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt());
            }

            throw new JsonParseException("Invalid number of args in array. Expected 3 but got " + array.size());
        }

        // If it's a primitive, try to read it as a long.
        else if (json.isJsonPrimitive()) {

            final JsonPrimitive primitive = json.getAsJsonPrimitive();

            if (primitive.isNumber()) {

                return class_2338.method_10092(json.getAsLong());
            }

            throw new JsonParseException("Expected JSON primitive to be a number.");
        }

        throw new JsonParseException("BlockPos data is not in a readable format.");
    }

    @Override
    public JsonElement toJSON(class_2338 toWrite) {

        final JsonObject object = new JsonObject();
        object.addProperty("x", toWrite.method_10263());
        object.addProperty("y", toWrite.method_10264());
        object.addProperty("z", toWrite.method_10260());
        return object;
    }

    @Override
    public class_2338 fromByteBuf(class_2540 buffer) {

        return class_2338.method_10092(buffer.readLong());
    }

    @Override
    public void toByteBuf(class_2540 buffer, class_2338 toWrite) {

        buffer.writeLong(toWrite.method_10063());
    }

    @Override
    public class_2520 toNBT(class_2338 toWrite) {

        final class_2487 tag = new class_2487();
        tag.method_10569("x", toWrite.method_10263());
        tag.method_10569("y", toWrite.method_10264());
        tag.method_10569("z", toWrite.method_10260());
        return tag;
    }

    @Override
    public class_2338 fromNBT(class_2520 nbt) {

        // If it's a compound explicitly read each axis.
        if (nbt instanceof class_2487 compound) {

            final int x = compound.method_10550("x");
            final int y = compound.method_10550("y");
            final int z = compound.method_10550("z");
            return new class_2338(x, y, z);
        }

        // If it's a list of 3 elements read in X,Y,Z order.
        else if (nbt instanceof class_2499 list) {

            if (list.size() == 3) {

                return new class_2338(Serializers.INT.fromNBT(list.method_10534(0)), Serializers.INT.fromNBT(list.method_10534(1)), Serializers.INT.fromNBT(list.method_10534(2)));
            }

            throw new NBTParseException("Invalid number of args in array. Expected 3 but got " + list.size());
        }

        // If it's a number, try to read it as a long.
        else if (nbt instanceof class_2514 numberTag) {

            return class_2338.method_10092(numberTag.method_10699());
        }

        throw new NBTParseException("BlockPos data is not in a readable format.");
    }

}
