package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1322;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class SerializerAttributeModifier implements ISerializer<class_1322> {

    public static final SerializerAttributeModifier SERIALIZER = new SerializerAttributeModifier();

    private SerializerAttributeModifier() {

    }

    @Override
    public class_1322 fromJSON(JsonElement json) {

        if (json instanceof JsonObject obj) {

            final Optional<UUID> id = Serializers.UUID.fromJSONOptional(obj, "uuid");
            final String name = Serializers.STRING.fromJSON(obj, "name");
            final double amount = Serializers.DOUBLE.fromJSON(obj, "amount");
            final class_1322.class_1323 operation = Serializers.ATTRIBUTE_OPERATION.fromJSON(obj, "operation");

            if (id.isPresent()) {

                return new class_1322(id.get(), name, amount, operation);
            }

            return new class_1322(name, amount, operation);
        }

        throw new JsonParseException("Expected JSON object.");
    }

    @Override
    public JsonElement toJSON(class_1322 toWrite) {

        final JsonObject json = new JsonObject();
        json.add("uuid", Serializers.UUID.toJSON(toWrite.method_6189()));
        json.add("name", Serializers.STRING.toJSON(toWrite.method_6185()));
        json.add("amount", Serializers.DOUBLE.toJSON(toWrite.method_6186()));
        json.add("operation", Serializers.ATTRIBUTE_OPERATION.toJSON(toWrite.method_6182()));
        return json;
    }

    @Override
    public class_1322 fromByteBuf(class_2540 buffer) {

        final UUID uuid = Serializers.UUID.fromByteBuf(buffer);
        final String name = Serializers.STRING.fromByteBuf(buffer);
        final double amount = Serializers.DOUBLE.fromByteBuf(buffer);
        final class_1322.class_1323 operation = Serializers.ATTRIBUTE_OPERATION.fromByteBuf(buffer);
        return new class_1322(uuid, name, amount, operation);
    }

    @Override
    public void toByteBuf(class_2540 buffer, class_1322 toWrite) {

        Serializers.UUID.toByteBuf(buffer, toWrite.method_6189());
        Serializers.STRING.toByteBuf(buffer, toWrite.method_6185());
        Serializers.DOUBLE.toByteBuf(buffer, toWrite.method_6186());
        Serializers.ATTRIBUTE_OPERATION.toByteBuf(buffer, toWrite.method_6182());
    }

    @Override
    public class_2520 toNBT(class_1322 toWrite) {

        return toWrite.method_26860();
    }

    @Override
    public class_1322 fromNBT(class_2520 nbt) {

        return class_1322.method_26859(Serializers.COMPOUND_TAG.fromNBT(nbt));
    }
}