package net.darkhax.bookshelf.api.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import net.darkhax.bookshelf.api.entity.merchant.MerchantTier;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VillagerTradeEntries {

    private final Map<class_3852, Multimap<Integer, class_3853.class_1652>> villagerTrades = new HashMap<>();
    private final List<class_3853.class_1652> rareTrades = new ArrayList<>();
    private final List<class_3853.class_1652> commonTrades = new ArrayList<>();

    public void addTrade(class_3852 profession, int tier, class_3853.class_1652 trade) {

        villagerTrades.computeIfAbsent(profession, p -> ArrayListMultimap.create()).put(tier, trade);
    }

    public void addTrade(class_3852 profession, MerchantTier tier, class_3853.class_1652 trade) {

        this.addTrade(profession, tier.ordinal() + 1, trade);
    }

    public void addWanderingTrade(class_3853.class_1652 trade, boolean isRare) {

        (isRare ? rareTrades : commonTrades).add(trade);
    }

    public void addRareWanderingTrade(class_3853.class_1652 trade) {

        this.addWanderingTrade(trade, true);
    }

    public void addCommonWanderingTrade(class_3853.class_1652 trade) {

        this.addWanderingTrade(trade, false);
    }

    public Map<class_3852, Multimap<Integer, class_3853.class_1652>> getVillagerTrades() {

        return this.villagerTrades;
    }

    public List<class_3853.class_1652> getRareWanderingTrades() {

        return this.rareTrades;
    }

    public List<class_3853.class_1652> getCommonWanderingTrades() {

        return this.commonTrades;
    }
}