package net.darkhax.bookshelf.api.registry;

import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import java.util.function.Supplier;

public class RegistryObject<T> extends CachedSupplier<T> implements IRegistryObject<T> {

    private final class_2960 id;

    protected RegistryObject(class_2960 id, Supplier<T> delegate) {

        super(delegate);
        this.id = id;
    }

    @Override
    public class_2960 getRegistryName() {

        return this.id;
    }

    public static <T> RegistryObject<?> deferred(class_2378<T> registry, String namespace, String id) {

        return deferred(registry, new class_2960(namespace, id));
    }

    public static <T> RegistryObject<?> deferred(class_2378<T> registry, class_2960 id) {

        return new RegistryObject<>(id, () -> registry.method_10223(id));
    }
}