package net.darkhax.bookshelf.api.item;

import net.darkhax.bookshelf.api.util.ItemStackHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_6880;

public class ItemStackBuilder {

    private class_1799 currentStack;

    public ItemStackBuilder(class_1935 item) {
        this(item, 1);
    }

    public ItemStackBuilder(class_6880<class_1792> holder) {
        this(holder.comp_349(), 1);
    }

    public ItemStackBuilder(class_6880<class_1792> holder, int count) {
        this(holder.comp_349(), count);
    }

    public ItemStackBuilder(class_1935 item, int count) {

        this(new class_1799(item, count));
    }

    public ItemStackBuilder(class_1799 stack) {

        this.currentStack = stack;
    }

    public ItemStackBuilder name(class_2561 name) {

        this.currentStack.method_7977(name);
        return this;
    }

    public ItemStackBuilder enchant(class_1887 enchantment) {

        return enchant(enchantment, 1);
    }

    public ItemStackBuilder enchant(class_1887 enchantment, int level) {

        this.currentStack.method_7978(enchantment, level);
        return this;
    }

    public ItemStackBuilder lore(class_2561... lines) {

        ItemStackHelper.setLore(this.currentStack, lines);
        return this;
    }

    public ItemStackBuilder addLore(class_2561... lines) {

        ItemStackHelper.appendLore(this.currentStack, lines);
        return this;
    }

    public class_1799 build() {

        return this.currentStack.method_7972();
    }
}