package net.darkhax.bookshelf.api.inventory;

import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.function.CachedSupplier;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import java.util.stream.IntStream;

public class ContainerInventoryAccess<T extends class_1263> implements IInventoryAccess {

    protected final T internal;
    private final CachedSupplier<int[]> availableSlots;

    public ContainerInventoryAccess(T internal) {

        this.internal = internal;
        this.availableSlots = CachedSupplier.cache(() -> IntStream.range(0, internal.method_5439()).toArray());
    }

    @Override
    public int[] getAvailableSlots(class_2350 side) {

        return this.availableSlots.get();
    }

    @Override
    public class_1799 getStackInSlot(int slot) {

        return this.internal.method_5438(slot);
    }

    @Override
    public class_1799 insert(int slot, class_1799 insertStack, class_2350 side, boolean modify) {

        return this.insert(slot, insertStack, side, modify, false);
    }

    public class_1799 insert(int slot, class_1799 insertStack, class_2350 side, boolean modify, boolean forceInsert) {

        if (insertStack.method_7960() || (!forceInsert && !this.isValidForSlot(slot, insertStack, side))) {

            return insertStack;
        }

        final class_1799 existingStack = internal.method_5438(slot);

        if (!existingStack.method_7960()) {

            // Existing slot is already full. Insertion can't be completed.
            if (existingStack.method_7947() >= Math.min(existingStack.method_7914(), getSlotSize(slot))) {

                return insertStack;
            }

            // The existing stack is not compatible with the inserted stack.
            if (!Services.INVENTORY_HELPER.canItemsStack(existingStack, insertStack)) {

                return insertStack;
            }

            // The amount of space we can fill.
            final int availableSpace = Math.min(insertStack.method_7914(), getSlotSize(slot) - existingStack.method_7947());

            // No space available
            if (availableSpace < 1) {

                return insertStack;
            }

            // All the inserted items can fit.
            if (insertStack.method_7947() <= availableSpace) {

                if (modify) {

                    final class_1799 replacement = insertStack.method_7972();
                    replacement.method_7933(existingStack.method_7947());
                    this.updateSlot(slot, replacement);
                }

                return class_1799.field_8037;
            }

            // The stack can only be partially inserted.
            else {

                final class_1799 uninserted = insertStack.method_7972();

                if (modify) {

                    final class_1799 replacement = uninserted.method_7971(availableSpace);
                    replacement.method_7933(existingStack.method_7947());
                    this.updateSlot(slot, replacement);
                    return uninserted;
                }

                uninserted.method_7934(availableSpace);
                return uninserted;
            }
        }

        // The slot is empty.
        else {

            final int availableSpace = Math.min(insertStack.method_7914(), getSlotSize(slot));

            // The slot doesn't have enough room.
            if (availableSpace < insertStack.method_7947()) {

                final class_1799 uninserted = insertStack.method_7972();

                if (modify) {

                    this.updateSlot(slot, uninserted.method_7971(availableSpace));
                    return uninserted;
                }

                uninserted.method_7934(availableSpace);
                return uninserted;
            }

            // The slot can accept the full stack.
            else {

                if (modify) {

                    this.updateSlot(slot, insertStack.method_7972());
                }

                return class_1799.field_8037;
            }
        }
    }

    @Override
    public class_1799 extract(int slot, int amount, class_2350 side, boolean modify) {

        if (amount == 0) {

            return class_1799.field_8037;
        }

        final class_1799 existingStack = internal.method_5438(slot);

        if (existingStack.method_7960()) {

            return class_1799.field_8037;
        }

        if (modify) {

            final int amountExtracted = Math.min(existingStack.method_7947(), amount);
            final class_1799 extracted = this.internal.method_5434(slot, amountExtracted);
            this.internal.method_5431();
            return extracted;
        }

        else {

            final class_1799 extracted = existingStack.method_7972();

            if (amount < extracted.method_7947()) {

                extracted.method_7939(amount);
            }

            return extracted;
        }
    }

    @Override
    public int getSlotSize(int slot) {

        return this.internal.method_5444();
    }

    @Override
    public boolean isValidForSlot(int slot, class_1799 stack, class_2350 side) {

        return this.internal.method_5437(slot, stack);
    }

    protected void updateSlot(int slot, class_1799 stack) {

        this.internal.method_5447(slot, stack);
        this.internal.method_5431();
    }
}