package net.darkhax.bookshelf.api.data.sound;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;

public class Sound implements ISound {

    public static final ISerializer<Sound> SERIALIZER = new Serializer();

    private final class_3414 sound;
    private final class_3419 category;
    private final float pitch;
    private final float volume;

    @Override
    public boolean equals(Object other) {

        if (this == other) {

            return true;
        }

        if (other == null || this.getClass() != other.getClass()) {

            return false;
        }

        Sound sound1 = (Sound) other;
        return Float.compare(sound1.pitch, pitch) == 0 && Float.compare(sound1.volume, volume) == 0 && sound.equals(sound1.sound) && category == sound1.category;
    }

    @Override
    public int hashCode() {

        return Objects.hash(sound, category, pitch, volume);
    }

    public Sound(class_3414 sound, class_3419 category, float pitch, float volume) {

        this.sound = sound;
        this.category = category;
        this.pitch = pitch;
        this.volume = volume;
    }

    @Override
    public void playSoundAt(class_1937 level, @Nullable class_1657 originator, double posX, double posY, double posZ) {

        level.method_43128(originator, posX, posY, posZ, sound, this.category, this.volume, this.pitch);
    }

    public static class Serializer implements ISerializer<Sound> {

        @Override
        public Sound fromJSON(JsonElement json) {

            if (json instanceof JsonObject obj) {

                final class_3414 sound = Serializers.SOUND_EVENT.fromJSON(obj, "sound");
                final class_3419 category = Serializers.SOUND_CATEGORY.fromJSON(obj, "category", class_3419.field_15250);
                final float pitch = Serializers.FLOAT.fromJSON(obj, "pitch", 1f);
                final float volume = Serializers.FLOAT.fromJSON(obj, "volume", 1f);

                if (pitch < 0 || pitch > 1) {

                    throw new JsonParseException("Pitch must be between 0 and 1. Read " + pitch);
                }

                if (volume < 0 || volume > 1) {

                    throw new JsonParseException("Volume must be between 0 and 1. Read " + volume);
                }

                return new Sound(sound, category, pitch, volume);
            }

            final class_3414 sound = Serializers.SOUND_EVENT.fromJSON(json);
            return new Sound(sound, class_3419.field_15250, 1f, 1f);
        }

        @Override
        public JsonElement toJSON(Sound toWrite) {

            final JsonObject obj = new JsonObject();
            obj.add("sound", Serializers.SOUND_EVENT.toJSON(toWrite.sound));
            obj.add("category", Serializers.SOUND_CATEGORY.toJSON(toWrite.category));
            obj.add("pitch", Serializers.FLOAT.toJSON(toWrite.pitch));
            obj.add("volume", Serializers.FLOAT.toJSON(toWrite.volume));
            return obj;
        }

        @Override
        public Sound fromByteBuf(class_2540 buffer) {

            final class_3414 sound = Serializers.SOUND_EVENT.fromByteBuf(buffer);
            final class_3419 category = Serializers.SOUND_CATEGORY.fromByteBuf(buffer);
            final float pitch = Serializers.FLOAT.fromByteBuf(buffer);
            final float volume = Serializers.FLOAT.fromByteBuf(buffer);
            return new Sound(sound, category, pitch, volume);
        }

        @Override
        public void toByteBuf(class_2540 buffer, Sound toWrite) {

            Serializers.SOUND_EVENT.toByteBuf(buffer, toWrite.sound);
            Serializers.SOUND_CATEGORY.toByteBuf(buffer, toWrite.category);
            Serializers.FLOAT.toByteBuf(buffer, toWrite.pitch);
            Serializers.FLOAT.toByteBuf(buffer, toWrite.volume);
        }

        @Override
        public class_2520 toNBT(Sound toWrite) {

            final class_2487 tag = new class_2487();
            tag.method_10566("sound", Serializers.SOUND_EVENT.toNBT(toWrite.sound));
            tag.method_10566("category", Serializers.SOUND_CATEGORY.toNBT(toWrite.category));
            tag.method_10566("pitch", Serializers.FLOAT.toNBT(toWrite.pitch));
            tag.method_10566("volume", Serializers.FLOAT.toNBT(toWrite.volume));
            return tag;
        }

        @Override
        public Sound fromNBT(class_2520 nbt) {

            if (nbt instanceof class_2487 tag) {

                final class_3414 sound = Serializers.SOUND_EVENT.fromNBT(tag, "sound");
                final class_3419 category = Serializers.SOUND_CATEGORY.fromNBT(tag, "category", class_3419.field_15250);
                final float pitch = Serializers.FLOAT.fromNBT(tag, "pitch", 1f);
                final float volume = Serializers.FLOAT.fromNBT(tag, "volume", 1f);

                if (pitch < 0 || pitch > 1) {

                    throw new NBTParseException("Pitch must be between 0 and 1. Read " + pitch);
                }

                if (volume < 0 || volume > 1) {

                    throw new NBTParseException("Volume must be between 0 and 1. Read " + volume);
                }

                return new Sound(sound, category, pitch, volume);
            }

            final class_3414 sound = Serializers.SOUND_EVENT.fromNBT(nbt);
            return new Sound(sound, class_3419.field_15250, 1f, 1f);
        }
    }
}