package net.darkhax.bookshelf.api.block;

import net.darkhax.bookshelf.api.block.entity.InventoryBlockEntity;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2624;
import net.minecraft.class_2680;

public abstract class InventoryBlock extends class_2237 {

    public InventoryBlock(class_2251 properties) {

        super(properties);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {

        // BaseEntityBlock uses INVISIBLE by default however I have personally found that model is a more convenient default for my block entities.
        return class_2464.field_11458;
    }

    @Override
    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {

        super.method_9567(world, pos, state, placer, stack);

        // Allow the custom name of the placer item to be applied to the placed block entity.
        if (stack.method_7938() && world.method_8321(pos) instanceof class_2624 container) {

            container.method_17488(stack.method_7964());
        }
    }

    @Override
    public void method_9536(class_2680 oldState, class_1937 world, class_2338 pos, class_2680 newState, boolean pushed) {

        // Drop the contents of the inventory.
        if (!newState.method_27852(oldState.method_26204()) && world.method_8321(pos) instanceof InventoryBlockEntity<?> invBlock) {

            invBlock.dropContents(oldState, world, pos);
        }

        super.method_9536(oldState, world, pos, newState, pushed);
    }
}